/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.session.SessionContext;

public class CurrentSessionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentSessionContext.class);
    private static final ThreadLocal<Deque<SessionContext>> CURRENT_CONTEXT = new ThreadLocal();

    @NotNull
    public static SessionContext get() {
        SessionContext sessionContext = CurrentSessionContext.getContextStack().peekLast();
        if (sessionContext == null) {
            String errorMessage = "CurrentSessionContext is not set but requested! Please use SessionContext.runWithContext(Runnable) to set the context.";
            IllegalStateException illegalStateException = new IllegalStateException(errorMessage);
            LOGGER.error(errorMessage, (Throwable)illegalStateException);
            throw illegalStateException;
        }
        return sessionContext;
    }

    public static SessionContext getOrNull() {
        return CurrentSessionContext.getContextStack().peekLast();
    }

    static void pushContext(SessionContext sessionContext) {
        CurrentSessionContext.getContextStack().addLast(sessionContext);
    }

    static void popContext() {
        CurrentSessionContext.getContextStack().removeLast();
    }

    private static Deque<SessionContext> getContextStack() {
        Deque<SessionContext> contextStack = CURRENT_CONTEXT.get();
        if (contextStack == null) {
            contextStack = new ArrayDeque<SessionContext>();
            CURRENT_CONTEXT.set(contextStack);
        }
        return contextStack;
    }
}

