/*-
 * ========================LICENSE_START=================================
 * TeamApps
 * ---
 * Copyright (C) 2014 - 2019 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.databinding;

import org.teamapps.event.Event;

public class TwoWayBindableValueImpl<T> implements TwoWayBindableValue<T> {

	public final Event<T> onChanged = new Event<>();

	private T value;

	public TwoWayBindableValueImpl() {
	}

	public TwoWayBindableValueImpl(T initialValue) {
		this.value = initialValue;
	}

	@Override
	public Event<T> onChanged() {
		return onChanged;
	}

	@Override
	public T get() {
		return value;
	}

	@Override
	public void set(T value) {
		this.value = value;
		onChanged.fire(value); // if you want to make this only fire when actually changed, be aware that every value class must implement equals in an appropriate way...
	}
}
