/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.login;

import org.teamapps.common.format.Color;
import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.Label;
import org.teamapps.ux.component.field.PasswordField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormConfigurationTemplate;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.SizingPolicy;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.panel.ElegantPanel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class LoginWindow {
    public Event<LoginData> onLogin = new Event();
    private SessionContext sessionContext = CurrentSessionContext.get();
    private TextField loginField;
    private PasswordField passwordField;
    private Button<BaseTemplateRecord> loginButton = new Button(BaseTemplate.FORM_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.CHECK, "Ok"));
    private Button<BaseTemplateRecord> registerButton;
    private Button<BaseTemplateRecord> forgotPasswordButton;
    private DisplayField errorField;
    private DisplayField headerField = new DisplayField(false, true);
    private Window window;
    private ElegantPanel elegantPanel;
    private final Label pwdLabel;
    private final Label loginLabel;

    public LoginWindow() {
        this.errorField = new DisplayField(false, true);
        this.loginField = new TextField();
        this.passwordField = new PasswordField();
        this.headerField.setValue("<span style='font-size:150%'>Login</span>");
        this.errorField.setValue("<span style='font-size:120%;color:#961900'>&nbsp;</span>");
        ResponsiveForm loginForm = new ResponsiveForm();
        ResponsiveFormConfigurationTemplate template = ResponsiveFormConfigurationTemplate.createDefault();
        loginForm.setConfigurationTemplate(template);
        ResponsiveFormLayout layout = loginForm.addResponsiveFormLayout(360);
        layout.addSection().setDrawHeaderLine(false).setPadding(new Spacing(30, 25)).setCollapsible(false);
        layout.addLabelField(this.headerField).setColSpan(2);
        layout.addLabelField(this.errorField).setColSpan(2);
        ResponsiveFormLayout.LabelAndField labelAndField = layout.addLabelAndField(null, this.sessionContext.getLocalized("ux.loginWindow.login", new Object[0]), this.loginField, true);
        labelAndField.label.getColumnDefinition().setWidthPolicy(SizingPolicy.AUTO);
        labelAndField.field.getColumnDefinition().setWidthPolicy(SizingPolicy.FRACTION);
        this.loginLabel = (Label)labelAndField.label.getField();
        this.pwdLabel = (Label)layout.addLabelAndField(null, (String)this.sessionContext.getLocalized((String)"ux.loginWindow.password", (Object[])new Object[0]), (AbstractField)this.passwordField, (boolean)true).label.getField();
        layout.addLabelField(this.loginButton, 1).setHorizontalAlignment(HorizontalElementAlignment.LEFT).setMinWidth(100).getRowDefinition().setTopPadding(10);
        this.loginButton.onValueChanged.addListener(value -> this.login());
        this.loginField.onSpecialKeyPressed.addListener(specialKey -> {
            if (specialKey == SpecialKey.ENTER) {
                this.login();
            }
        });
        this.passwordField.onSpecialKeyPressed.addListener(specialKey -> {
            if (specialKey == SpecialKey.ENTER) {
                this.login();
            }
        });
        this.window = new Window();
        this.window.setHideTitleBar(true);
        this.window.setModal(true);
        this.window.setHeight(300);
        this.window.setWidth(470);
        this.window.setBodyBackgroundColor(Color.WHITE.withAlpha(0.8f));
        this.window.setContent(loginForm);
        this.elegantPanel = new ElegantPanel(loginForm);
        this.elegantPanel.setMaxContentWidth(400);
    }

    private void login() {
        String login = this.getLogin();
        String password = this.getPassword();
        if (login != null && !login.isEmpty() && password != null && !password.isEmpty()) {
            this.onLogin.fire(new LoginData(login, password));
        } else {
            this.setError();
        }
    }

    public void focusLogin() {
        this.loginField.focus();
    }

    public ElegantPanel getElegantPanel() {
        return this.elegantPanel;
    }

    public void showLoginWindow(int animationDuration) {
        this.window.show(animationDuration);
        this.focusLogin();
    }

    public void closeLoginWindow(int animationDuration) {
        this.window.close(animationDuration);
    }

    public Window getLoginWindow() {
        return this.window;
    }

    public void setError() {
        this.errorField.setValue("<span style='font-size:120%;color:#961900'>" + this.sessionContext.getLocalized("ux.loginWindow.wrongUserNameOrPassword", new Object[0]) + "</span>");
    }

    public void removeErrorMessage() {
        this.errorField.setValue("");
    }

    public String getLogin() {
        return (String)this.loginField.getValue();
    }

    public String getPassword() {
        return (String)this.passwordField.getValue();
    }

    public TextField getLoginField() {
        return this.loginField;
    }

    public PasswordField getPasswordField() {
        return this.passwordField;
    }

    public Label getPwdLabel() {
        return this.pwdLabel;
    }

    public Label getLoginLabel() {
        return this.loginLabel;
    }

    public Button getLoginButton() {
        return this.loginButton;
    }

    public Button getRegisterButton() {
        return this.registerButton;
    }

    public Button getForgotPasswordButton() {
        return this.forgotPasswordButton;
    }

    public DisplayField getErrorField() {
        return this.errorField;
    }

    public DisplayField getHeaderField() {
        return this.headerField;
    }

    public static class LoginData {
        public String login;
        public String password;

        public LoginData(String login, String password) {
            this.login = login;
            this.password = password;
        }
    }
}

