/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.teamapps.icons.api.Icon;
import org.teamapps.icons.api.StaticIcon;
import org.teamapps.ux.session.SessionContext;

public class UxJacksonSerializationTemplate {
    private static final SimpleModule UX_SERIALIZERS_JACKSON_MODULE = new UxSerializersJacksonModule();
    private static final ThreadLocal<SessionContext> SESSION_CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private SessionContext sessionContext;

    public UxJacksonSerializationTemplate(ObjectMapper objectMapper, SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        if (!objectMapper.getRegisteredModuleIds().contains(UxSerializersJacksonModule.class)) {
            objectMapper.registerModule((Module)UX_SERIALIZERS_JACKSON_MODULE);
        }
    }

    public void doWithUxJacksonSerializers(Runnable runnable) {
        SESSION_CONTEXT_THREAD_LOCAL.set(this.sessionContext);
        try {
            runnable.run();
        }
        finally {
            SESSION_CONTEXT_THREAD_LOCAL.remove();
        }
    }

    private static SessionContext getCurrentSessionContext() {
        return SESSION_CONTEXT_THREAD_LOCAL.get();
    }

    public static class UxSerializersJacksonModule
    extends SimpleModule {
        public UxSerializersJacksonModule() {
            this.addSerializer(Icon.class, (JsonSerializer)new JsonSerializer<Icon>(){

                public void serialize(Icon icon, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    SessionContext currentSessionContext = UxJacksonSerializationTemplate.getCurrentSessionContext();
                    gen.writeString(currentSessionContext.resolveIcon(icon));
                }

                public void serializeWithType(Icon value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
                    this.serialize(value, gen, serializers);
                }
            });
            this.addDeserializer(Icon.class, (JsonDeserializer)new JsonDeserializer<Icon>(){

                public Icon deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                    String qualifiedIconId = p.getText();
                    return new StaticIcon(qualifiedIconId);
                }
            });
        }

        public Object getTypeId() {
            return ((Object)((Object)this)).getClass();
        }
    }
}

