/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.task;

import org.teamapps.event.Event;
import org.teamapps.ux.task.ObservableProgress;
import org.teamapps.ux.task.ProgressChangeEventData;
import org.teamapps.ux.task.ProgressMonitor;
import org.teamapps.ux.task.ProgressStatus;

public class Progress
implements ProgressMonitor,
ObservableProgress {
    public final Event<ProgressChangeEventData> onChanged = new Event();
    private String statusMessage;
    private double progress = -1.0;
    private boolean cancelable = false;
    private ProgressStatus status = ProgressStatus.NOT_YET_STARTED;

    @Override
    public Event<ProgressChangeEventData> onChanged() {
        return this.onChanged;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public boolean isCancelable() {
        return this.cancelable;
    }

    @Override
    public void requestCancellation() {
        if (this.status.ordinal() < ProgressStatus.CANCELLATION_REQUESTED.ordinal()) {
            this.status = ProgressStatus.CANCELLATION_REQUESTED;
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isCancellationRequested() {
        return this.status == ProgressStatus.CANCELLATION_REQUESTED;
    }

    @Override
    public ProgressStatus getStatus() {
        return this.status;
    }

    @Override
    public void start() {
        this.startIfNotYetStarted();
    }

    private void startIfNotYetStarted() {
        if (this.status.ordinal() < ProgressStatus.RUNNING.ordinal()) {
            this.status = ProgressStatus.RUNNING;
            this.fireChangeEvent();
        }
    }

    @Override
    public void setProgress(double progress) {
        this.startIfNotYetStarted();
        if (this.status.ordinal() == ProgressStatus.RUNNING.ordinal()) {
            this.progress = progress;
            this.fireChangeEvent();
        }
    }

    @Override
    public void setProgress(double progress, String statusMessage) {
        this.startIfNotYetStarted();
        if (this.status.ordinal() == ProgressStatus.RUNNING.ordinal()) {
            this.progress = progress;
            this.statusMessage = statusMessage;
            this.fireChangeEvent();
        }
    }

    @Override
    public void setStatusMessage(String statusMessage) {
        this.startIfNotYetStarted();
        if (this.status.ordinal() == ProgressStatus.RUNNING.ordinal()) {
            this.statusMessage = statusMessage;
            this.fireChangeEvent();
        }
    }

    @Override
    public void markCanceled() {
        if (this.status.ordinal() < ProgressStatus.CANCELED.ordinal()) {
            this.status = ProgressStatus.CANCELED;
            this.fireChangeEvent();
        }
    }

    @Override
    public void markCanceled(String statusMessage) {
        if (this.status.ordinal() < ProgressStatus.CANCELED.ordinal()) {
            this.status = ProgressStatus.CANCELED;
            this.statusMessage = statusMessage;
            this.fireChangeEvent();
        }
    }

    @Override
    public void markCompleted() {
        if (this.status.ordinal() < ProgressStatus.CANCELED.ordinal()) {
            this.status = ProgressStatus.COMPLETE;
            this.fireChangeEvent();
        }
    }

    @Override
    public void markCompleted(String statusMessage) {
        if (this.status.ordinal() < ProgressStatus.CANCELED.ordinal()) {
            this.status = ProgressStatus.COMPLETE;
            this.statusMessage = statusMessage;
            this.fireChangeEvent();
        }
    }

    @Override
    public void markFailed() {
        if (this.status.ordinal() < ProgressStatus.CANCELED.ordinal()) {
            this.status = ProgressStatus.FAILED;
            this.fireChangeEvent();
        }
    }

    @Override
    public void markFailed(String message) {
        if (this.status.ordinal() < ProgressStatus.CANCELED.ordinal()) {
            this.status = ProgressStatus.FAILED;
            this.statusMessage = message;
            this.fireChangeEvent();
        }
    }

    @Override
    public void setCancelable(boolean cancelable) {
        if (this.status.ordinal() < ProgressStatus.CANCELED.ordinal()) {
            this.cancelable = cancelable;
            this.fireChangeEvent();
        }
    }

    private void fireChangeEvent() {
        this.onChanged().fire(new ProgressChangeEventData(this.status, this.statusMessage, this.progress, this.cancelable));
    }
}

