/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiCommand;
import org.teamapps.server.SessionRecorder;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.UiCommandExecutor;
import org.teamapps.uisession.UiCommandWithResultCallback;

public class CommandDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandDispatcher.class);
    private final UiCommandExecutor commandExecutor;
    private final QualifiedUiSessionId qualifiedUiSessionId;
    private final List<UiCommandWithResultCallback> uiCommands = Collections.synchronizedList(new ArrayList());
    private boolean closed;
    private SessionRecorder sessionRecorder;

    public CommandDispatcher(UiCommandExecutor commandExecutor, QualifiedUiSessionId qualifiedUiSessionId, SessionRecorder sessionRecorder) {
        this.commandExecutor = commandExecutor;
        this.qualifiedUiSessionId = qualifiedUiSessionId;
        this.sessionRecorder = sessionRecorder;
    }

    public <RESULT> void queueCommand(UiCommand<RESULT> command, Consumer<RESULT> resultCallback) {
        if (!this.closed) {
            this.uiCommands.add(new UiCommandWithResultCallback<RESULT>(command, resultCallback));
        } else {
            LOGGER.debug("Not queuing command because already closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCommands() {
        if (this.uiCommands.isEmpty()) {
            return;
        }
        if (!this.closed) {
            CommandDispatcher commandDispatcher = this;
            synchronized (commandDispatcher) {
                ArrayList<UiCommandWithResultCallback> commandsCopy;
                List<UiCommandWithResultCallback> list = this.uiCommands;
                synchronized (list) {
                    commandsCopy = new ArrayList<UiCommandWithResultCallback>(this.uiCommands);
                    this.uiCommands.clear();
                }
                this.commandExecutor.sendCommands(this.qualifiedUiSessionId, commandsCopy);
                if (this.sessionRecorder != null) {
                    this.sessionRecorder.recordCommands(commandsCopy.stream().map(UiCommandWithResultCallback::getUiCommand).collect(Collectors.toList()));
                }
            }
        }
        LOGGER.debug("Not flushing commands because already closed.");
    }

    public void close() {
        this.closed = true;
        this.uiCommands.clear();
    }
}

