/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiKeySequentialExecutor<K> {
    private static Logger LOGGER = LoggerFactory.getLogger(MultiKeySequentialExecutor.class);
    private Map<K, CompletableFuture<?>> lastFutureByKey = new HashMap();
    private ExecutorService pool;

    public MultiKeySequentialExecutor(int nThreads) {
        this.pool = Executors.newFixedThreadPool(nThreads);
    }

    public MultiKeySequentialExecutor(ExecutorService executorService) {
        this.pool = executorService;
    }

    public synchronized CompletableFuture<Void> submit(K key, Runnable task) {
        return this.submit(key, () -> {
            task.run();
            return null;
        });
    }

    public synchronized <V> CompletableFuture<V> submit(K key, Supplier<V> task) {
        CompletionStage returnedFuture = this.lastFutureByKey.computeIfAbsent(key, k -> CompletableFuture.completedFuture(null)).thenApplyAsync(o -> task.get(), (Executor)this.pool);
        this.lastFutureByKey.put(key, (CompletableFuture<?>)((CompletableFuture)returnedFuture).exceptionally(throwable -> {
            LOGGER.error("Error while executing: ", throwable);
            return null;
        }));
        return returnedFuture;
    }

    public synchronized void closeForKey(K key) {
        CompletableFuture<?> lastFuture = this.lastFutureByKey.get(key);
        if (lastFuture != null) {
            lastFuture.cancel(false);
            this.lastFutureByKey.remove(key);
        }
    }

    public SequentialExecutor getExecutorForKey(K key) {
        return new SequentialExecutor(key);
    }

    public class SequentialExecutor
    implements Executor {
        private final K key;

        public SequentialExecutor(K key) {
            this.key = key;
        }

        @Override
        public void execute(Runnable command) {
            MultiKeySequentialExecutor.this.submit(this.key, command);
        }

        public CompletableFuture<Void> submit(Runnable runnable) {
            return MultiKeySequentialExecutor.this.submit(this.key, runnable);
        }

        public <V> CompletableFuture<V> submit(Supplier<V> task) {
            return MultiKeySequentialExecutor.this.submit(this.key, task);
        }

        public void close() {
            MultiKeySequentialExecutor.this.closeForKey(this.key);
        }
    }
}

