/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.MultiWriteLockableValue;
import org.teamapps.ux.component.field.validator.FieldValidator;
import org.teamapps.ux.session.CurrentSessionContext;

public abstract class AbstractField<VALUE>
extends AbstractComponent {
    private static final FieldValidator REQUIRED_VALIDATOR = (field, value) -> field.isEmpty() ? Collections.singletonList(new FieldMessage(FieldMessage.Severity.ERROR, CurrentSessionContext.get().getLocalized("dict.requiredField", new Object[0]))) : null;
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractField.class);
    public final Event<VALUE> onValueChanged = new Event();
    public final Event<Boolean> onVisibilityChanged = new Event();
    private FieldEditingMode editingMode = FieldEditingMode.EDITABLE;
    private final Set<FieldValidator<VALUE>> validators = new HashSet<FieldValidator<VALUE>>();
    private final Map<FieldValidator<VALUE>, List<FieldMessage>> fieldMessagesByValidator = new HashMap<FieldValidator<VALUE>, List<FieldMessage>>();
    private FieldMessage.Position defaultMessagePosition = FieldMessage.Position.BELOW;
    private FieldMessage.Visibility defaultMessageVisibility = FieldMessage.Visibility.ALWAYS_VISIBLE;
    private MultiWriteLockableValue<VALUE> value = new MultiWriteLockableValue<Object>(null);

    public AbstractField() {
        this.getSessionContext().onDestroyed().addListener(aVoid -> this.destroy());
    }

    public FieldEditingMode getEditingMode() {
        return this.editingMode;
    }

    public void setEditingMode(FieldEditingMode editingMode) {
        this.editingMode = editingMode;
        this.queueCommandIfRendered(() -> new UiField.SetEditingModeCommand(this.getId(), editingMode.toUiFieldEditingMode()));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.onVisibilityChanged.fire(visible);
    }

    public void focus() {
        this.queueCommandIfRendered(() -> new UiField.FocusCommand(this.getId()));
    }

    protected void mapAbstractFieldAttributesToUiField(UiField uiField) {
        this.mapAbstractUiComponentProperties((UiComponent)uiField);
        uiField.setValue(this.convertUxValueToUiValue(this.value.read()));
        uiField.setEditingMode(this.editingMode.toUiFieldEditingMode());
        uiField.setFieldMessages(this.getFieldMessages().stream().map(message -> message.createUiFieldMessage(this.defaultMessagePosition, this.defaultMessageVisibility)).collect(Collectors.toList()));
    }

    public void setValue(VALUE value) {
        MultiWriteLockableValue.Lock lock = this.value.writeAndLock(value);
        Object uiValue = this.convertUxValueToUiValue(value);
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiField.SetValueCommand(this.getId(), uiValue), aVoid -> lock.release());
        } else {
            lock.release();
        }
    }

    protected MultiWriteLockableValue.Lock setAndLockValue(VALUE value) {
        return this.value.writeAndLock(value);
    }

    public Object convertUxValueToUiValue(VALUE value) {
        return value;
    }

    public VALUE getValue() {
        return this.value.read();
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_FIELD_VALUE_CHANGED: {
                this.applyValueFromUi(((UiField.ValueChangedEvent)event).getValue());
                this.validate();
            }
        }
    }

    protected void applyValueFromUi(Object value) {
        if (!this.value.isLocked()) {
            VALUE transformedValue = this.convertUiValueToUxValue(value);
            if (!this.value.isLocked()) {
                this.value.writeIfNotLocked(transformedValue);
                this.onValueChanged.fire(transformedValue);
            }
        }
    }

    public VALUE convertUiValueToUxValue(Object value) {
        return (VALUE)value;
    }

    public boolean isEmpty() {
        return this.getValue() == null;
    }

    public Collection<FieldValidator<VALUE>> getValidators() {
        return Collections.unmodifiableSet(this.validators);
    }

    public void addValidator(FieldValidator<VALUE> validator) {
        this.validators.add(validator);
    }

    public void removeValidator(FieldValidator<VALUE> validator) {
        this.validators.remove(validator);
        this.fieldMessagesByValidator.remove(validator);
        this.updateFieldMessages();
    }

    public List<FieldMessage> validate() {
        ArrayList<FieldMessage> allValidatorMessages = new ArrayList<FieldMessage>();
        if (this.validators.size() > 0) {
            for (FieldValidator<VALUE> validator : this.validators) {
                this.fieldMessagesByValidator.remove(validator);
                List<FieldMessage> messages = validator.validate(this, this.getValue());
                if (messages == null) {
                    messages = Collections.emptyList();
                }
                this.fieldMessagesByValidator.put(validator, messages);
                allValidatorMessages.addAll(messages);
            }
            this.updateFieldMessages();
        }
        return allValidatorMessages;
    }

    public void setRequired(boolean required) {
        if (required) {
            this.addValidator(REQUIRED_VALIDATOR);
        } else {
            this.removeValidator(REQUIRED_VALIDATOR);
        }
    }

    public boolean isRequired() {
        return this.validators.contains(REQUIRED_VALIDATOR);
    }

    public List<FieldMessage> getFieldMessages() {
        return this.fieldMessagesByValidator.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<FieldMessage> getCustomFieldMessages() {
        return this.fieldMessagesByValidator.computeIfAbsent(null, v -> new ArrayList());
    }

    public void setCustomFieldMessages(List<FieldMessage> fieldMessages) {
        this.fieldMessagesByValidator.put(null, new ArrayList<FieldMessage>(fieldMessages));
        this.updateFieldMessages();
    }

    public void addCustomFieldMessage(FieldMessage fieldMessage) {
        this.getCustomFieldMessages().add(fieldMessage);
        this.updateFieldMessages();
    }

    public void removeCustomFieldMessage(FieldMessage fieldMessage) {
        this.getCustomFieldMessages().remove(fieldMessage);
        this.updateFieldMessages();
    }

    public void clearCustomFieldMessages() {
        this.getCustomFieldMessages().clear();
        this.updateFieldMessages();
    }

    private void updateFieldMessages() {
        this.queueCommandIfRendered(() -> new UiField.SetFieldMessagesCommand(this.getId(), this.getFieldMessages().stream().map(fieldMessage -> fieldMessage.createUiFieldMessage(this.defaultMessagePosition, this.defaultMessageVisibility)).collect(Collectors.toList())));
    }

    public boolean isValid() {
        return this.getMaxFieldMessageSeverity() != FieldMessage.Severity.ERROR;
    }

    public FieldMessage.Severity getMaxFieldMessageSeverity() {
        return this.getFieldMessages().stream().map(fieldMessage -> fieldMessage.getSeverity()).max(Comparator.comparing(severity -> severity.ordinal())).orElse(null);
    }

    public FieldMessage.Position getDefaultMessagePosition() {
        return this.defaultMessagePosition;
    }

    public void setDefaultMessagePosition(FieldMessage.Position defaultMessagePosition) {
        this.defaultMessagePosition = defaultMessagePosition;
    }

    public FieldMessage.Visibility getDefaultMessageVisibility() {
        return this.defaultMessageVisibility;
    }

    public void setDefaultMessageVisibility(FieldMessage.Visibility defaultMessageVisibility) {
        this.defaultMessageVisibility = defaultMessageVisibility;
    }
}

