/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.session.SessionContext;

public class CurrentSessionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentSessionContext.class);
    private static final ThreadLocal<SessionContext> CURRENT_CONTEXT = new ThreadLocal();

    @NotNull
    public static SessionContext get() {
        SessionContext sessionContext = CURRENT_CONTEXT.get();
        if (sessionContext == null) {
            String errorMessage = "CurrentSessionContext is not set but requested! Please use SessionContext.runWithContext(Runnable) to set the context.";
            IllegalStateException illegalStateException = new IllegalStateException(errorMessage);
            LOGGER.error(errorMessage, (Throwable)illegalStateException);
            throw illegalStateException;
        }
        return sessionContext;
    }

    public static SessionContext getOrNull() {
        return CURRENT_CONTEXT.get();
    }

    static void set(SessionContext sessionContext) {
        CURRENT_CONTEXT.set(sessionContext);
    }

    static void unset() {
        CURRENT_CONTEXT.remove();
    }
}

