/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value.filter;

import java.util.Objects;
import org.teamapps.data.value.DataRecord;
import org.teamapps.data.value.filter.AbstractFilter;
import org.teamapps.data.value.filter.FilterType;

public class BooleanFilter
extends AbstractFilter {
    private final boolean value;

    public BooleanFilter(String property, boolean value) {
        super(property);
        this.value = value;
    }

    @Override
    public FilterType getType() {
        return FilterType.BOOLEAN;
    }

    @Override
    public boolean matches(DataRecord record, boolean treatNullAsDefaultValue) {
        Object recordValue = record.getValue(this.getProperty());
        if (recordValue == null) {
            if (treatNullAsDefaultValue) {
                return !this.value;
            }
            return false;
        }
        return Objects.equals(this.value, recordValue);
    }

    @Override
    public String explain(int filterLevel) {
        return this.createLevelIndentString(filterLevel) + "BOOLEAN: " + this.getProperty() + " = " + this.value + "\n";
    }

    public Boolean getValue() {
        return this.value;
    }
}

