/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.event;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class Event<EVENT_DATA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Event.class);
    private final String source;
    private List<Consumer<EVENT_DATA>> listeners = new CopyOnWriteArrayList<Consumer<EVENT_DATA>>();
    private EVENT_DATA lastEventData;

    public Event() {
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
        this.source = stackTraceElement.getFileName() + stackTraceElement.getLineNumber();
    }

    public void addListener(Consumer<EVENT_DATA> listener) {
        this.addListener(listener, true);
    }

    public void addListener(Consumer<EVENT_DATA> listener, boolean bindToSessionContext) {
        if (bindToSessionContext) {
            SessionContext currentSessionContext = CurrentSessionContext.getOrNull();
            this.listeners.add(new SessionContextAwareEventListener<EVENT_DATA>(currentSessionContext, listener));
            if (currentSessionContext != null) {
                this.removeWhenSessionDestroyed(listener, currentSessionContext);
            }
        } else {
            this.listeners.add(listener);
        }
    }

    public void addListener(Runnable listener) {
        this.addListener((EVENT_DATA eventData) -> listener.run(), true);
    }

    public void addListener(Runnable listener, boolean bindToSessionContext) {
        this.addListener((EVENT_DATA eventData) -> listener.run(), bindToSessionContext);
    }

    private void removeWhenSessionDestroyed(Consumer<EVENT_DATA> listener, SessionContext currentSessionContext) {
        if (this != currentSessionContext.onDestroyed()) {
            WeakReference<Consumer<EVENT_DATA>> listenerWeakReference = new WeakReference<Consumer<EVENT_DATA>>(listener);
            currentSessionContext.onDestroyed().listeners.add(aVoid -> {
                Consumer l = (Consumer)listenerWeakReference.get();
                if (l != null) {
                    this.removeListener(l);
                }
            });
        }
    }

    public void removeListener(Consumer<EVENT_DATA> listener) {
        this.listeners.remove(new SessionContextAwareEventListener<EVENT_DATA>(listener));
    }

    public void fire(EVENT_DATA eventData) {
        this.lastEventData = eventData;
        for (Consumer<EVENT_DATA> listener : this.listeners) {
            listener.accept(eventData);
        }
    }

    public void fire() {
        this.fire(null);
    }

    public void fireIfChanged(EVENT_DATA eventData) {
        if (!Objects.equals(this.lastEventData, eventData)) {
            this.fire(eventData);
        }
    }

    public <T> Event<T> converted(Function<EVENT_DATA, T> converter) {
        Event newEvent = new Event();
        this.addListener((EVENT_DATA data) -> newEvent.fire(converter.apply(data)));
        return newEvent;
    }

    private static class SessionContextAwareEventListener<EVENT_DATA>
    implements Consumer<EVENT_DATA> {
        private final SessionContext sessionContext;
        private final Consumer<EVENT_DATA> delegate;

        public SessionContextAwareEventListener(SessionContext sessionContext, Consumer<EVENT_DATA> delegate) {
            this.sessionContext = sessionContext;
            this.delegate = delegate;
        }

        public SessionContextAwareEventListener(Consumer<EVENT_DATA> delegate) {
            this(null, delegate);
        }

        @Override
        public void accept(EVENT_DATA eventData) {
            if (this.sessionContext != null) {
                this.sessionContext.runWithContext(() -> this.delegate.accept(eventData));
            } else {
                this.delegate.accept(eventData);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionContextAwareEventListener that = (SessionContextAwareEventListener)o;
            return this.delegate != null ? this.delegate.equals(that.delegate) : that.delegate == null;
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }
}

