/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.absolutelayout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.dto.UiAbsoluteLayout;
import org.teamapps.dto.UiAbsolutePositionedComponent;
import org.teamapps.dto.UiAbsolutePositioning;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.absolutelayout.AbsolutePosition;
import org.teamapps.ux.component.absolutelayout.AnimationEasing;

public class AbsoluteLayout
extends AbstractComponent {
    private Map<Component, AbsolutePosition> positionsByComponent = new HashMap<Component, AbsolutePosition>();
    private AnimationEasing animationEasing = AnimationEasing.EASE;
    private int animationDuration = 200;

    public void putComponent(Component component, AbsolutePosition positioning) {
        this.positionsByComponent.put(component, positioning);
        this.updateUiLayout();
    }

    public void putComponents(Map<Component, AbsolutePosition> positioningByComponent, boolean removeExisting) {
        if (removeExisting) {
            this.positionsByComponent.clear();
        }
        this.positionsByComponent.putAll(positioningByComponent);
        this.updateUiLayout();
    }

    public void removeComponent(Component component) {
        this.positionsByComponent.remove(component);
        this.updateUiLayout();
    }

    private void updateUiLayout() {
        this.queueCommandIfRendered(() -> new UiAbsoluteLayout.UpdateCommand(this.getId(), this.createUiAbsolutePositionedComponents(), this.animationDuration, this.animationEasing.toUiAnimationEasing()));
    }

    private List<UiAbsolutePositionedComponent> createUiAbsolutePositionedComponents() {
        return this.positionsByComponent.entrySet().stream().map(entry -> {
            Component component = (Component)entry.getKey();
            AbsolutePosition position = (AbsolutePosition)entry.getValue();
            return new UiAbsolutePositionedComponent(component.createUiComponentReference(), new UiAbsolutePositioning(position.getTop() != null ? position.getTop().toCssString() : null, position.getRight() != null ? position.getRight().toCssString() : null, position.getBottom() != null ? position.getBottom().toCssString() : null, position.getLeft() != null ? position.getLeft().toCssString() : null, position.getWidth() != null ? position.getWidth().toCssString() : null, position.getHeight() != null ? position.getHeight().toCssString() : null, position.getZIndex()));
        }).collect(Collectors.toList());
    }

    public UiAbsoluteLayout createUiComponent() {
        UiAbsoluteLayout uiAbsoluteLayout = new UiAbsoluteLayout();
        this.mapAbstractUiComponentProperties((UiComponent)uiAbsoluteLayout);
        uiAbsoluteLayout.setComponents(this.createUiAbsolutePositionedComponents());
        return uiAbsoluteLayout;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    @Override
    protected void doDestroy() {
        this.positionsByComponent.keySet().forEach(component -> component.destroy());
    }

    public AnimationEasing getAnimationEasing() {
        return this.animationEasing;
    }

    public void setAnimationEasing(AnimationEasing animationEasing) {
        this.animationEasing = animationEasing;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
    }
}

