/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.richtext;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiRichTextEditor;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.richtext.ImageUploadFailedEventData;
import org.teamapps.ux.component.field.richtext.ImageUploadStartedEventData;
import org.teamapps.ux.component.field.richtext.ImageUploadSuccessfulEventData;
import org.teamapps.ux.component.field.richtext.ImageUploadTooLargeEventData;
import org.teamapps.ux.component.field.richtext.ToolbarVisibilityMode;
import org.teamapps.ux.component.field.richtext.UploadedFileToUrlConverter;
import org.teamapps.ux.component.field.upload.UploadedFile;
import org.teamapps.ux.component.field.upload.UploadedFileAccessException;

public class RichTextEditor
extends AbstractField<String>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    public final Event<ImageUploadTooLargeEventData> onImageUploadTooLarge = new Event();
    public final Event<ImageUploadStartedEventData> onImageUploadStarted = new Event();
    public final Event<ImageUploadSuccessfulEventData> onImageUploadSuccessful = new Event();
    public final Event<ImageUploadFailedEventData> onImageUploadFailed = new Event();
    private ToolbarVisibilityMode toolbarVisibilityMode = ToolbarVisibilityMode.VISIBLE;
    private int minHeight = 150;
    private int maxHeight;
    private String uploadUrl = "/upload";
    private int maxImageFileSizeInBytes = 5000000;
    private UploadedFileToUrlConverter uploadedFileToUrlConverter = file -> this.getSessionContext().createFileLink(this.getSessionContext().getUploadedFileByUuid(file.getUuid()));

    public UiField createUiComponent() {
        UiRichTextEditor field = new UiRichTextEditor();
        this.mapAbstractFieldAttributesToUiField((UiField)field);
        field.setToolbarVisibilityMode(this.toolbarVisibilityMode.toToolbarVisibilityMode());
        field.setUploadUrl(this.uploadUrl);
        field.setMaxImageFileSizeInBytes((long)this.maxImageFileSizeInBytes);
        field.setMinHeight(this.minHeight);
        field.setMaxHeight(this.maxHeight);
        return field;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        if (!this.defaultHandleTextInputEvent(event)) {
            switch (event.getUiEventType()) {
                case UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_TOO_LARGE: {
                    UiRichTextEditor.ImageUploadTooLargeEvent tooLargeEvent = (UiRichTextEditor.ImageUploadTooLargeEvent)event;
                    this.onImageUploadTooLarge.fire(new ImageUploadTooLargeEventData(tooLargeEvent.getFileName(), tooLargeEvent.getMimeType(), tooLargeEvent.getSizeInBytes()));
                    break;
                }
                case UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_STARTED: {
                    UiRichTextEditor.ImageUploadStartedEvent uploadStartedEvent = (UiRichTextEditor.ImageUploadStartedEvent)event;
                    this.onImageUploadStarted.fire(new ImageUploadStartedEventData(uploadStartedEvent.getFileName(), uploadStartedEvent.getMimeType(), uploadStartedEvent.getSizeInBytes(), uploadStartedEvent.getIncompleteUploadsCount()));
                    break;
                }
                case UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_SUCCESSFUL: {
                    UiRichTextEditor.ImageUploadSuccessfulEvent imageUploadedEvent = (UiRichTextEditor.ImageUploadSuccessfulEvent)event;
                    this.onImageUploadSuccessful.fire(new ImageUploadSuccessfulEventData(imageUploadedEvent.getFileUuid(), imageUploadedEvent.getName(), imageUploadedEvent.getMimeType(), imageUploadedEvent.getSizeInBytes(), imageUploadedEvent.getIncompleteUploadsCount()));
                    String fileUuid = imageUploadedEvent.getFileUuid();
                    UploadedFile uploadedFile = new UploadedFile(imageUploadedEvent.getFileUuid(), imageUploadedEvent.getName(), imageUploadedEvent.getSizeInBytes(), imageUploadedEvent.getMimeType(), () -> {
                        try {
                            return new FileInputStream(this.getSessionContext().getUploadedFileByUuid(imageUploadedEvent.getFileUuid()));
                        }
                        catch (FileNotFoundException e) {
                            throw new UploadedFileAccessException(e);
                        }
                    }, () -> this.getSessionContext().getUploadedFileByUuid(imageUploadedEvent.getFileUuid()));
                    this.queueCommandIfRendered(() -> new UiRichTextEditor.SetUploadedImageUrlCommand(this.getId(), fileUuid, this.uploadedFileToUrlConverter.convert(uploadedFile)));
                    break;
                }
                case UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_FAILED: {
                    UiRichTextEditor.ImageUploadFailedEvent uploadFailedEvent = (UiRichTextEditor.ImageUploadFailedEvent)event;
                    this.onImageUploadFailed.fire(new ImageUploadFailedEventData(uploadFailedEvent.getName(), uploadFailedEvent.getMimeType(), uploadFailedEvent.getSizeInBytes(), uploadFailedEvent.getIncompleteUploadsCount()));
                }
            }
        }
    }

    @Override
    protected void doDestroy() {
    }

    public ToolbarVisibilityMode getToolbarVisibilityMode() {
        return this.toolbarVisibilityMode;
    }

    public void setToolbarVisibilityMode(ToolbarVisibilityMode toolbarVisibilityMode) {
        this.toolbarVisibilityMode = toolbarVisibilityMode;
        this.queueCommandIfRendered(() -> new UiRichTextEditor.SetToolbarVisibilityModeCommand(this.getId(), toolbarVisibilityMode.toToolbarVisibilityMode()));
    }

    public UploadedFileToUrlConverter getUploadedFileToUrlConverter() {
        return this.uploadedFileToUrlConverter;
    }

    public void setUploadedFileToUrlConverter(UploadedFileToUrlConverter uploadedFileToUrlConverter) {
        this.uploadedFileToUrlConverter = uploadedFileToUrlConverter;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        this.queueCommandIfRendered(() -> new UiRichTextEditor.SetUploadUrlCommand(this.getId(), uploadUrl));
    }

    public int getMaxImageFileSizeInBytes() {
        return this.maxImageFileSizeInBytes;
    }

    public void setMaxImageFileSizeInBytes(int maxImageFileSizeInBytes) {
        this.maxImageFileSizeInBytes = maxImageFileSizeInBytes;
        this.queueCommandIfRendered(() -> new UiRichTextEditor.SetMaxImageFileSizeInBytesCommand(this.getId(), (long)maxImageFileSizeInBytes));
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        this.queueCommandIfRendered(() -> new UiRichTextEditor.SetMinHeightCommand(this.getId(), minHeight));
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        this.queueCommandIfRendered(() -> new UiRichTextEditor.SetMaxHeightCommand(this.getId(), maxHeight));
    }

    public void setFixedHeight(int height) {
        this.minHeight = height;
        this.maxHeight = height;
        this.queueCommandIfRendered(() -> new UiRichTextEditor.SetMinHeightCommand(this.getId(), height));
        this.queueCommandIfRendered(() -> new UiRichTextEditor.SetMaxHeightCommand(this.getId(), height));
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

