/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiMediaSoupPlaybackParamaters;
import org.teamapps.dto.UiMediaSoupPublishingParameters;
import org.teamapps.dto.UiMediaSoupV2WebRtcClient;
import org.teamapps.dto.UiObject;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.webrtc.AudioTrackConstraints;
import org.teamapps.ux.component.webrtc.MulticastPlaybackProfile;
import org.teamapps.ux.component.webrtc.ScreenSharingConstraints;
import org.teamapps.ux.component.webrtc.VideoTrackConstraints;

public class MediaSoupV2WebRtcClient
extends AbstractComponent {
    public final Event<MulticastPlaybackProfile> onPlaybackProfileChanged = new Event();
    public final Event<Boolean> onVoiceActivityChanged = new Event();
    public final Event<Void> onClicked = new Event();
    private String serverAddress;
    private int serverPort;
    private boolean activityLineVisible;
    private Color activityInactiveColor;
    private Color activityActiveColor;
    private boolean active;
    private Icon icon;
    private String caption;
    private String noVideoImageUrl;
    private Float displayAreaAspectRatio = Float.valueOf(1.3333334f);
    private UiObject lastPublishOrPlaybackParams;

    public MediaSoupV2WebRtcClient() {
    }

    public MediaSoupV2WebRtcClient(String serverUrl) {
        URL url;
        try {
            url = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.serverAddress = url.getHost();
        this.serverPort = url.getPort();
    }

    public MediaSoupV2WebRtcClient(String serverAddress, int serverPort) {
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    public UiMediaSoupV2WebRtcClient createUiComponent() {
        UiMediaSoupV2WebRtcClient ui = new UiMediaSoupV2WebRtcClient();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setInitialPlaybackOrPublishParams((Object)this.lastPublishOrPlaybackParams);
        ui.setActivityLineVisible(this.activityLineVisible);
        ui.setActivityInactiveColor(UiUtil.createUiColor(this.activityInactiveColor));
        ui.setActivityActiveColor(UiUtil.createUiColor(this.activityActiveColor));
        ui.setIcon(this.getSessionContext().resolveIcon(this.icon));
        ui.setCaption(this.caption);
        ui.setNoVideoImageUrl(this.noVideoImageUrl);
        ui.setDisplayAreaAspectRatio(this.displayAreaAspectRatio);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_PROFILE_CHANGED: {
                UiMediaSoupV2WebRtcClient.PlaybackProfileChangedEvent e = (UiMediaSoupV2WebRtcClient.PlaybackProfileChangedEvent)event;
                if (e.getProfile() == null) {
                    return;
                }
                MulticastPlaybackProfile profile = Arrays.stream(MulticastPlaybackProfile.values()).filter(p -> Objects.equals(p.name(), e.getProfile().name())).findFirst().orElse(null);
                if (profile == null) {
                    return;
                }
                this.onPlaybackProfileChanged.fire(MulticastPlaybackProfile.valueOf(e.getProfile().name()));
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_VOICE_ACTIVITY_CHANGED: {
                UiMediaSoupV2WebRtcClient.VoiceActivityChangedEvent e = (UiMediaSoupV2WebRtcClient.VoiceActivityChangedEvent)event;
                this.onVoiceActivityChanged.fire(e.getActive());
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CLICKED: {
                UiMediaSoupV2WebRtcClient.ClickedEvent e = (UiMediaSoupV2WebRtcClient.ClickedEvent)event;
                this.onClicked.fire();
                break;
            }
        }
    }

    public void publish(String uid, String token, AudioTrackConstraints audioConstraints, VideoTrackConstraints videoConstraints, ScreenSharingConstraints screenSharingConstraints, long maxBitrate) {
        UiMediaSoupPublishingParameters params = new UiMediaSoupPublishingParameters();
        params.setServerAdress(this.serverAddress);
        params.setServerPort(this.serverPort);
        params.setUid(uid);
        params.setToken(token);
        params.setAudioConstraints(audioConstraints != null ? audioConstraints.createUiAudioTrackConstraints() : null);
        params.setVideoConstraints(videoConstraints != null ? videoConstraints.createUiVideoTrackConstraints() : null);
        params.setScreenSharingConstraints(screenSharingConstraints != null ? screenSharingConstraints.createUiScreenSharingConstraints() : null);
        params.setMaxBitrate(maxBitrate);
        if (this.isRendered()) {
            this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.PublishCommand(this.getId(), params));
        } else {
            this.lastPublishOrPlaybackParams = params;
        }
    }

    public void play(String uid, boolean audio, boolean video, long minBitrate, long maxBitrate) {
        UiMediaSoupPlaybackParamaters params = new UiMediaSoupPlaybackParamaters();
        params.setServerAdress(this.serverAddress);
        params.setServerPort(this.serverPort);
        params.setUid(uid);
        params.setAudio(audio);
        params.setVideo(video);
        params.setMinBitrate(minBitrate);
        params.setMaxBitrate(maxBitrate);
        if (this.isRendered()) {
            this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.PlaybackCommand(this.getId(), params));
        } else {
            this.lastPublishOrPlaybackParams = params;
        }
    }

    public void stop() {
        if (this.isRendered()) {
            this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.StopCommand(this.getId()));
        } else {
            this.lastPublishOrPlaybackParams = null;
        }
    }

    private void update() {
        this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isActivityLineVisible() {
        return this.activityLineVisible;
    }

    public void setActivityLineVisible(boolean activityLineVisible) {
        this.activityLineVisible = activityLineVisible;
        this.update();
    }

    public Color getActivityInactiveColor() {
        return this.activityInactiveColor;
    }

    public void setActivityInactiveColor(Color activityInactiveColor) {
        this.activityInactiveColor = activityInactiveColor;
        this.update();
    }

    public Color getActivityActiveColor() {
        return this.activityActiveColor;
    }

    public void setActivityActiveColor(Color activityActiveColor) {
        this.activityActiveColor = activityActiveColor;
        this.update();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active != this.active) {
            this.active = active;
            this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.SetActiveCommand(this.getId(), active));
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (!Objects.equals(icon, this.icon)) {
            this.icon = icon;
            this.update();
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        if (!Objects.equals(caption, this.caption)) {
            this.caption = caption;
            this.update();
        }
    }

    public String getNoVideoImageUrl() {
        return this.noVideoImageUrl;
    }

    public void setNoVideoImageUrl(String noVideoImageUrl) {
        this.noVideoImageUrl = noVideoImageUrl;
        this.update();
    }

    public UiObject getLastPublishOrPlaybackParams() {
        return this.lastPublishOrPlaybackParams;
    }

    public void setLastPublishOrPlaybackParams(UiObject lastPublishOrPlaybackParams) {
        this.lastPublishOrPlaybackParams = lastPublishOrPlaybackParams;
        this.update();
    }

    public Float getDisplayAreaAspectRatio() {
        return this.displayAreaAspectRatio;
    }

    public void setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
        this.displayAreaAspectRatio = displayAreaAspectRatio;
        this.update();
    }
}

