/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value.filter;

import java.util.Objects;
import org.teamapps.data.value.DataRecord;
import org.teamapps.data.value.filter.AbstractFilter;
import org.teamapps.data.value.filter.FilterType;

public class IdValueFilter
extends AbstractFilter {
    private final Object value;
    private final Comparator comparator;

    public IdValueFilter(String property, Object value, Comparator comparator) {
        super(property);
        this.value = value;
        this.comparator = comparator;
    }

    @Override
    public FilterType getType() {
        return FilterType.ID_VALUE;
    }

    @Override
    public boolean matches(DataRecord record, boolean treatNullAsDefaultValue) {
        Number recordValue = (Number)record.getValue(this.getProperty());
        long matchValue = 0L;
        if (recordValue != null) {
            matchValue = recordValue.longValue();
        }
        if (!treatNullAsDefaultValue && recordValue == null) {
            return false;
        }
        switch (this.comparator) {
            case EQUAL: {
                return this.matchEqual(recordValue, treatNullAsDefaultValue);
            }
            case UNEQUAL: {
                return !this.matchEqual(recordValue, treatNullAsDefaultValue);
            }
            case SMALLER: {
                return matchValue < ((Number)this.value).longValue();
            }
            case SMALLER_OR_EQUAL: {
                return matchValue <= ((Number)this.value).longValue();
            }
            case GREATER: {
                return matchValue > ((Number)this.value).longValue();
            }
            case GREATER_OR_EQUAL: {
                return matchValue >= ((Number)this.value).longValue();
            }
        }
        return false;
    }

    private boolean matchEqual(Object recordValue, boolean treatNullAsDefaultValue) {
        if (recordValue == null) {
            if (treatNullAsDefaultValue) {
                return this.value == null;
            }
            return false;
        }
        return Objects.equals(recordValue, this.value);
    }

    @Override
    public String explain(int filterLevel) {
        return this.createLevelIndentString(filterLevel) + "ID-VALUE: " + this.getProperty() + " " + this.comparator.name() + " " + this.value + "\n";
    }

    public Object getValue() {
        return this.value;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public static enum Comparator {
        EQUAL,
        UNEQUAL,
        SMALLER,
        SMALLER_OR_EQUAL,
        GREATER,
        GREATER_OR_EQUAL;

    }
}

