/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.event.Event;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.timegraph.Interval;

public class FilterProvider<RECORD> {
    public Event<String> onFullTextSearchUpdate = new Event();
    public Event<String> onTimeGraphIntervalUpdate = new Event();
    private List<TextField> fullTextSearchFields = new ArrayList<TextField>();
    private String fullTextFilter;
    private Interval timeGraphFilter;
    private List<String> timeGraphProperties;
    private Map<String, String> tablePropertyFilter = new HashMap<String, String>();

    public void createSearchHeaderField(View view, boolean leftSide) {
        Panel panel = view.getPanel();
        TextField fullTextSearchField = new TextField();
        fullTextSearchField.setEmptyText("Search...");
        fullTextSearchField.setShowClearButton(true);
        fullTextSearchField.onTextInput.addListener(query -> this.handleFullTextSearchFieldUpdate(fullTextSearchField, (String)query));
        if (leftSide) {
            if (panel.getLeftHeaderField() == null) {
                panel.setLeftHeaderField(fullTextSearchField);
            }
        } else if (panel.getRightHeaderField() == null) {
            panel.setRightHeaderField(fullTextSearchField);
        }
    }

    private void handleFullTextSearchFieldUpdate(TextField originatingField, String value) {
        for (TextField searchField : this.fullTextSearchFields) {
            if (originatingField.equals(searchField)) continue;
            searchField.setValue(value);
        }
        this.fullTextFilter = value;
        this.onFullTextSearchUpdate.fire(this.fullTextFilter);
    }

    public String getFullTextFilter() {
        return this.fullTextFilter;
    }

    public Interval getTimeGraphFilter() {
        return this.timeGraphFilter;
    }

    public void clearTablePropertyFilters() {
        this.tablePropertyFilter.clear();
    }

    public void setTablePropertyFilter(String propertyName, String filter) {
        this.tablePropertyFilter.put(propertyName, filter);
    }
}

