/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.media.webrtc;

import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiWebRtcPlayer;
import org.teamapps.dto.UiWebRtcPublisher;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.media.webrtc.WebRtcPublishingMediaSettings;
import org.teamapps.ux.component.media.webrtc.WebRtcPublishingSettings;

public class WebRtcPublisher
extends AbstractComponent {
    private WebRtcPublishingSettings publishingSettings;
    private boolean microphoneMuted = false;
    private String backgroundImageUrl;

    @Override
    public UiComponent createUiComponent() {
        UiWebRtcPublisher ui = new UiWebRtcPublisher();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setPublishingSettings(this.publishingSettings != null ? this.publishingSettings.createUWebRtcPublishingSettings() : null);
        ui.setMicrophoneMuted(this.microphoneMuted);
        ui.setBackgroundImageUrl(this.backgroundImageUrl);
        return ui;
    }

    public void publish(String signalingUrl, String wowzaApplicationName, String streamName, WebRtcPublishingMediaSettings inputSettings) {
        this.publishingSettings = new WebRtcPublishingSettings(signalingUrl, wowzaApplicationName, streamName, inputSettings);
        this.queueCommandIfRendered(() -> new UiWebRtcPublisher.PublishCommand(this.getId(), this.publishingSettings.createUWebRtcPublishingSettings()));
    }

    public void unPublish() {
        this.publishingSettings = null;
        this.queueCommandIfRendered(() -> new UiWebRtcPublisher.UnPublishCommand(this.getId()));
    }

    public void setMicrophoneMuted(boolean microphoneMuted) {
        this.microphoneMuted = microphoneMuted;
        this.queueCommandIfRendered(() -> new UiWebRtcPublisher.SetMicrophoneMutedCommand(this.getId(), microphoneMuted));
    }

    public String getBackgroundImageUrl() {
        return this.backgroundImageUrl;
    }

    public void setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
        this.queueCommandIfRendered(() -> new UiWebRtcPlayer.SetBackgroundImageUrlCommand(this.getId(), backgroundImageUrl));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    @Override
    protected void doDestroy() {
    }
}

