/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc;

import org.teamapps.dto.UiAudioTrackConstraints;

public class AudioTrackConstraints {
    private int channelCount = 1;
    private boolean autoGainControl = true;
    private boolean echoCancellation = true;
    private boolean noiseSuppression = true;

    public AudioTrackConstraints() {
    }

    public AudioTrackConstraints(boolean autoGainControl, boolean echoCancellation, boolean noiseSuppression) {
        this.autoGainControl = autoGainControl;
        this.echoCancellation = echoCancellation;
        this.noiseSuppression = noiseSuppression;
    }

    public AudioTrackConstraints(int channelCount, boolean autoGainControl, boolean echoCancellation, boolean noiseSuppression) {
        this.channelCount = channelCount;
        this.autoGainControl = autoGainControl;
        this.echoCancellation = echoCancellation;
        this.noiseSuppression = noiseSuppression;
    }

    public UiAudioTrackConstraints createUiAudioTrackConstraints() {
        UiAudioTrackConstraints ui = new UiAudioTrackConstraints();
        ui.setChannelCount(this.channelCount);
        ui.setAutoGainControl(this.autoGainControl);
        ui.setEchoCancellation(this.echoCancellation);
        ui.setNoiseSuppression(this.noiseSuppression);
        return ui;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int channelCount) {
        this.channelCount = channelCount;
    }

    public boolean isAutoGainControl() {
        return this.autoGainControl;
    }

    public void setAutoGainControl(boolean autoGainControl) {
        this.autoGainControl = autoGainControl;
    }

    public boolean isEchoCancellation() {
        return this.echoCancellation;
    }

    public void setEchoCancellation(boolean echoCancellation) {
        this.echoCancellation = echoCancellation;
    }

    public boolean isNoiseSuppression() {
        return this.noiseSuppression;
    }

    public void setNoiseSuppression(boolean noiseSuppression) {
        this.noiseSuppression = noiseSuppression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioTrackConstraints that = (AudioTrackConstraints)o;
        if (this.channelCount != that.channelCount) {
            return false;
        }
        if (this.autoGainControl != that.autoGainControl) {
            return false;
        }
        if (this.echoCancellation != that.echoCancellation) {
            return false;
        }
        return this.noiseSuppression == that.noiseSuppression;
    }

    public int hashCode() {
        int result = this.channelCount;
        result = 31 * result + (this.autoGainControl ? 1 : 0);
        result = 31 * result + (this.echoCancellation ? 1 : 0);
        result = 31 * result + (this.noiseSuppression ? 1 : 0);
        return result;
    }
}

