/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc;

import org.teamapps.dto.UiVideoTrackConstraints;
import org.teamapps.ux.component.webrtc.VideoFacingMode;

public class VideoTrackConstraints {
    private int width = 800;
    private int height = 600;
    private VideoFacingMode facingMode = VideoFacingMode.USER;
    private int frameRate = 20;

    public VideoTrackConstraints() {
    }

    public VideoTrackConstraints(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public VideoTrackConstraints(int width, int height, VideoFacingMode facingMode, int frameRate) {
        this.width = width;
        this.height = height;
        this.facingMode = facingMode;
        this.frameRate = frameRate;
    }

    public UiVideoTrackConstraints createUiVideoTrackConstraints() {
        UiVideoTrackConstraints ui = new UiVideoTrackConstraints();
        ui.setHeight(Integer.valueOf(this.height));
        ui.setWidth(Integer.valueOf(this.width));
        ui.setFacingMode(this.facingMode.toUiVideoFacingMode());
        ui.setFrameRate((double)this.frameRate);
        return ui;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public VideoFacingMode getFacingMode() {
        return this.facingMode;
    }

    public void setFacingMode(VideoFacingMode facingMode) {
        this.facingMode = facingMode;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoTrackConstraints that = (VideoTrackConstraints)o;
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (this.frameRate != that.frameRate) {
            return false;
        }
        return this.facingMode == that.facingMode;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + (this.facingMode != null ? this.facingMode.hashCode() : 0);
        result = 31 * result + this.frameRate;
        return result;
    }
}

