/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.dialogue;

import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.flexcontainer.FlexSizeUnit;
import org.teamapps.ux.component.flexcontainer.FlexSizingPolicy;
import org.teamapps.ux.component.flexcontainer.HorizontalLayout;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.window.Window;

public class FormDialogue
extends Window {
    public Event<Boolean> onResult = new Event();
    private TemplateField<BaseTemplateRecord<?>> comboBox;
    private Integer buttonLineIndex;
    private ResponsiveFormLayout formLayout;
    private HorizontalLayout buttonRow;

    public static FormDialogue create(Icon icon, String title, String text) {
        return new FormDialogue(icon, title, text);
    }

    public FormDialogue(Icon icon, String title, String text) {
        this(icon, null, title, text);
    }

    public FormDialogue(Icon icon, String imageUrl, String title, String text) {
        this.setIcon(icon);
        this.setTitle(title);
        this.setWidth(550);
        this.setHeight(350);
        ResponsiveForm responsiveForm = new ResponsiveForm(0, 200, 0);
        this.formLayout = responsiveForm.addResponsiveFormLayout(450);
        this.formLayout.addSection().setDrawHeaderLine(false).setCollapsible(false).setMargin(new Spacing(10)).setGridGap(20);
        this.comboBox = new TemplateField(BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES, new BaseTemplateRecord(icon, imageUrl, title, text, null));
        this.formLayout.addField(0, 0, "header", this.comboBox).setHorizontalAlignment(HorizontalElementAlignment.LEFT).setColSpan(3);
        this.setContent(responsiveForm);
    }

    public void addField(Icon icon, String caption, AbstractField<?> field) {
        this.formLayout.addLabelAndField((Icon)icon, (String)caption, field).field.setColSpan(2);
    }

    public void addOkCancelButtons(String okCaption, String cancelCaption) {
        this.addOkButton(okCaption);
        this.addCancelButton(cancelCaption);
    }

    public void addOkCancelButtons(Icon okIcon, String okCaption, Icon cancelIcon, String cancelCaption) {
        this.addOkButton(okIcon, okCaption);
        this.addCancelButton(cancelIcon, cancelCaption);
    }

    public Button<?> addOkButton(String caption) {
        return this.addOkButton((Icon)MaterialIcon.CHECK, caption);
    }

    public Button<?> addOkButton(Icon icon, String caption) {
        this.createButtonRowIfNotExists();
        Button<BaseTemplateRecord> okButton = Button.create(icon, caption);
        okButton.onValueChanged.addListener(o -> this.onResult.fire(true));
        this.buttonRow.addComponent(okButton, new FlexSizingPolicy(0.0f, FlexSizeUnit.AUTO, 1, 1));
        return okButton;
    }

    private void createButtonRowIfNotExists() {
        if (this.buttonRow == null) {
            this.buttonRow = new HorizontalLayout();
            this.formLayout.addLabelAndComponent((Component)this.buttonRow).field.setColSpan(2);
        }
    }

    public Button<?> addCancelButton(String caption) {
        return this.addCancelButton((Icon)MaterialIcon.CANCEL, caption);
    }

    public Button<?> addCancelButton(Icon icon, String caption) {
        this.createButtonRowIfNotExists();
        Button<BaseTemplateRecord> cancelButton = Button.create(icon, caption);
        cancelButton.setCssStyle("margin-left", "10px");
        cancelButton.onValueChanged.addListener(o -> {
            this.close(250);
            this.getSessionContext().flushCommands();
            this.onResult.fire(false);
        });
        this.buttonRow.addComponent(cancelButton, new FlexSizingPolicy(0.0f, FlexSizeUnit.AUTO, 1, 1));
        return cancelButton;
    }

    private int getButtonLineIndex() {
        if (this.buttonLineIndex == null) {
            this.buttonLineIndex = this.formLayout.getLastNonEmptyRowInSection() + 1;
        }
        return this.buttonLineIndex;
    }
}

