/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.BeanPropertyInjector;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyInjector;
import org.teamapps.ux.component.field.AbstractField;

public class LogicalForm<RECORD> {
    private final Map<String, AbstractField> fieldsByPropertyName = new HashMap<String, AbstractField>();
    private PropertyExtractor<RECORD> propertyExtractor = new BeanPropertyExtractor();
    private PropertyInjector<RECORD> propertyInjector = new BeanPropertyInjector();

    public LogicalForm() {
    }

    public LogicalForm(PropertyExtractor<RECORD> propertyExtractor, PropertyInjector<RECORD> propertyInjector) {
        this.propertyExtractor = propertyExtractor;
        this.propertyInjector = propertyInjector;
    }

    public LogicalForm(Map<String, AbstractField> fieldsByPropertyName) {
        fieldsByPropertyName.putAll(fieldsByPropertyName);
    }

    public LogicalForm<RECORD> addField(String propertyName, AbstractField field) {
        this.fieldsByPropertyName.put(propertyName, field);
        return this;
    }

    public LogicalForm<RECORD> removeField(AbstractField field) {
        this.fieldsByPropertyName.remove(field);
        return this;
    }

    public void applyRecordValuesToFields(RECORD record) {
        Map<String, Object> values = this.propertyExtractor.getValues(record, this.fieldsByPropertyName.keySet());
        values.forEach((dataKey, value) -> this.fieldsByPropertyName.get(dataKey).setValue(value));
    }

    public void applyFieldValuesToRecord(RECORD record) {
        Map fieldValues = this.fieldsByPropertyName.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), ((AbstractField)entry.getValue()).getValue()), Map::putAll);
        this.propertyInjector.setValues(record, fieldValues);
    }

    public Map<String, AbstractField> getFields() {
        return this.fieldsByPropertyName;
    }

    public PropertyExtractor<RECORD> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public PropertyInjector<RECORD> getPropertyInjector() {
        return this.propertyInjector;
    }

    public void setPropertyInjector(PropertyInjector<RECORD> propertyInjector) {
        this.propertyInjector = propertyInjector;
    }
}

