/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.dto.AbstractUiLineChartDataDisplay;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiLongInterval;
import org.teamapps.dto.UiTimeChartZoomLevel;
import org.teamapps.dto.UiTimeGraph;
import org.teamapps.dto.UiTimeGraphDataPoint;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.timegraph.AbstractLineChartDataDisplay;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartDataPoints;
import org.teamapps.ux.component.timegraph.LineChartLine;
import org.teamapps.ux.component.timegraph.LineChartMouseScrollZoomPanMode;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.TimeGraphZoomLevel;
import org.teamapps.ux.component.timegraph.ZoomEventData;

public class TimeGraph
extends AbstractComponent {
    public final Event<ZoomEventData> onZoomed = new Event();
    public final Event<Interval> onIntervalSelected = new Event();
    private final List<AbstractLineChartDataDisplay> lines = new ArrayList<AbstractLineChartDataDisplay>();
    private int maxPixelsBetweenDataPoints = 50;
    private TimeGraphModel model;
    private LineChartMouseScrollZoomPanMode mouseScrollZoomPanMode = LineChartMouseScrollZoomPanMode.ENABLED;
    private Interval selectedInterval;
    private final Consumer<Void> onTimeGraphDataChangedListener = this::onTimeGraphDataChanged;

    public TimeGraph(TimeGraphModel model) {
        this.model = model;
        this.setModel(model);
    }

    public void addLine(String dataSeriesId, LineChartCurveType graphType, float dataDotRadius, Color lineColor) {
        this.addLine(new LineChartLine(dataSeriesId, graphType, dataDotRadius, lineColor, null));
    }

    public void addLine(String dataSeriesId, LineChartCurveType graphType, float dataDotRadius, Color lineColor, Color areaColor) {
        this.addLine(new LineChartLine(dataSeriesId, graphType, dataDotRadius, lineColor, areaColor));
    }

    public void addLine(AbstractLineChartDataDisplay lineFormat) {
        this.addDataDisplay(lineFormat);
    }

    public void addDataDisplay(AbstractLineChartDataDisplay lineFormat) {
        this.lines.add(lineFormat);
        this.setLines(new ArrayList<AbstractLineChartDataDisplay>(this.lines));
    }

    public void setLines(List<? extends AbstractLineChartDataDisplay> lineFormats) {
        this.lines.clear();
        lineFormats.forEach(line -> {
            this.lines.add((AbstractLineChartDataDisplay)line);
            line.setChangeListener(display -> this.queueCommandIfRendered(() -> new UiTimeGraph.SetLineCommand(this.getId(), display.getId(), display.createUiFormat())));
        });
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetLinesCommand(this.getId(), this.toUiLineFormats(lineFormats)));
        this.refresh();
    }

    private List<AbstractUiLineChartDataDisplay> toUiLineFormats(List<? extends AbstractLineChartDataDisplay> lineFormats) {
        return lineFormats.stream().map(AbstractLineChartDataDisplay::createUiFormat).collect(Collectors.toList());
    }

    public List<String> getLineDataIds() {
        return this.lines.stream().flatMap(lineChartDataDisplay -> lineChartDataDisplay.getDataSeriesIds().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    public UiComponent createUiComponent() {
        List<UiTimeChartZoomLevel> uiZoomLevels = this.createUiZoomlevels();
        Interval domainX = this.model.getDomainX(this.getLineDataIds());
        if (domainX == null) {
            domainX = new Interval(0L, 1L);
        }
        UiLongInterval uiIntervalX = new Interval(domainX.getMin(), domainX.getMax()).createUiLongInterval();
        UiTimeGraph uiTimeGraph = new UiTimeGraph(uiIntervalX, uiZoomLevels, this.maxPixelsBetweenDataPoints, this.toUiLineFormats(this.lines));
        this.mapAbstractUiComponentProperties((UiComponent)uiTimeGraph);
        uiTimeGraph.setMouseScrollZoomPanMode(this.mouseScrollZoomPanMode.toUiLineChartMouseScrollZoomPanMode());
        return uiTimeGraph;
    }

    private List<UiTimeChartZoomLevel> createUiZoomlevels() {
        return this.model.getZoomLevels().stream().map(TimeGraphZoomLevel::createUiTimeChartZoomLevel).collect(Collectors.toList());
    }

    @Override
    protected void doDestroy() {
        this.unregisterModelListeners();
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TIME_GRAPH_DATA_NEEDED: {
                UiTimeGraph.DataNeededEvent dataNeededEvent = (UiTimeGraph.DataNeededEvent)event;
                Interval interval = new Interval(dataNeededEvent.getNeededIntervalX().getMin(), dataNeededEvent.getNeededIntervalX().getMax());
                TimeGraphZoomLevel zoomLevel = this.model.getZoomLevels().get(dataNeededEvent.getZoomLevelIndex());
                Map<String, LineChartDataPoints> data = this.model.getDataPoints(this.getLineDataIds(), zoomLevel, interval);
                this.queueCommandIfRendered(() -> new UiTimeGraph.AddDataCommand(this.getId(), dataNeededEvent.getZoomLevelIndex(), dataNeededEvent.getNeededIntervalX(), this.convertToUiData(data)));
                break;
            }
            case UI_TIME_GRAPH_ZOOMED: {
                UiTimeGraph.ZoomedEvent zoomedEvent = (UiTimeGraph.ZoomedEvent)event;
                Interval interval = new Interval(zoomedEvent.getIntervalX().getMin(), zoomedEvent.getIntervalX().getMax());
                this.onZoomed.fire(new ZoomEventData(interval, zoomedEvent.getZoomLevelIndex()));
                break;
            }
            case UI_TIME_GRAPH_INTERVAL_SELECTED: {
                Interval interval;
                UiTimeGraph.IntervalSelectedEvent selectedEvent = (UiTimeGraph.IntervalSelectedEvent)event;
                this.selectedInterval = interval = selectedEvent.getIntervalX() != null ? new Interval(selectedEvent.getIntervalX().getMin(), selectedEvent.getIntervalX().getMax()) : null;
                this.onIntervalSelected.fire(interval);
                break;
            }
        }
    }

    private Map<String, List<UiTimeGraphDataPoint>> convertToUiData(Map<String, LineChartDataPoints> data) {
        HashMap<String, List<UiTimeGraphDataPoint>> uiData = new HashMap<String, List<UiTimeGraphDataPoint>>();
        data.forEach((dataSeriesId, dataPoints) -> {
            ArrayList<UiTimeGraphDataPoint> uiList = new ArrayList<UiTimeGraphDataPoint>();
            for (int i = 0; i < dataPoints.size(); ++i) {
                uiList.add(new UiTimeGraphDataPoint(dataPoints.getX(i), dataPoints.getY(i)));
            }
            uiData.put((String)dataSeriesId, (List<UiTimeGraphDataPoint>)uiList);
        });
        return uiData;
    }

    public void refresh() {
        this.queueCommandIfRendered(() -> new UiTimeGraph.ResetAllDataCommand(this.getId(), this.createUiZoomlevels()));
    }

    public void zoomTo(long minX, long maxX) {
        this.queueCommandIfRendered(() -> new UiTimeGraph.ZoomToCommand(this.getId(), new UiLongInterval(minX, maxX)));
    }

    public int getMaxPixelsBetweenDataPoints() {
        return this.maxPixelsBetweenDataPoints;
    }

    public void setMaxPixelsBetweenDataPoints(int maxPixelsBetweenDataPoints) {
        this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetMaxPixelsBetweenDataPointsCommand(this.getId(), maxPixelsBetweenDataPoints));
    }

    public LineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
        return this.mouseScrollZoomPanMode;
    }

    public void setMouseScrollZoomPanMode(LineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
        this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetMouseScrollZoomPanModeCommand(this.getId(), mouseScrollZoomPanMode.toUiLineChartMouseScrollZoomPanMode()));
    }

    public Interval getSelectedInterval() {
        return this.selectedInterval;
    }

    public void setSelectedInterval(Interval selectedInterval) {
        this.selectedInterval = selectedInterval;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetSelectedIntervalCommand(this.getId(), selectedInterval.createUiLongInterval()));
    }

    public void setModel(TimeGraphModel model) {
        this.unregisterModelListeners();
        if (model != null) {
            model.onDataChanged().addListener(this.onTimeGraphDataChangedListener);
        }
        this.model = model;
        this.refresh();
    }

    private void unregisterModelListeners() {
        if (this.model != null) {
            this.model.onDataChanged().removeListener(this.onTimeGraphDataChangedListener);
        }
    }

    private void onTimeGraphDataChanged(Void aVoid) {
        Interval domainX = this.model.getDomainX(this.getLineDataIds());
        UiLongInterval uiIntervalX = new Interval(domainX.getMin(), domainX.getMax()).createUiLongInterval();
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetIntervalXCommand(this.getId(), uiIntervalX));
        this.refresh();
    }
}

