/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.teamapps.ux.resource.InputStreamResource;

public interface Resource {
    public InputStream getInputStream();

    default public long getLength() {
        try {
            int len;
            InputStream inputStream = this.getInputStream();
            byte[] buf = new byte[4096];
            int totalLength = 0;
            while ((len = inputStream.read(buf)) != -1) {
                totalLength += len;
            }
            return totalLength;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    default public String getName() {
        return null;
    }

    default public Date getLastModified() {
        return new Date();
    }

    default public Date getExpires() {
        return new Date(System.currentTimeMillis() + 604800000L);
    }

    default public String getMimeType() {
        return null;
    }

    default public boolean isAttachment() {
        return false;
    }

    default public File getAsFile() {
        try {
            String name = this.getName() != null ? this.getName() : ".bin";
            File tempFile = File.createTempFile("temp", name);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));
            IOUtils.copyLarge((InputStream)this.getInputStream(), (OutputStream)bos);
            bos.close();
            return tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Resource create(Supplier<InputStream> inputStreamSupplier, long length) {
        return new InputStreamResource(inputStreamSupplier, length);
    }
}

