/*-
 * ========================LICENSE_START=================================
 * TeamApps
 * ---
 * Copyright (C) 2014 - 2020 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.ux.application.validation;

import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.FieldMessage.Position;
import org.teamapps.ux.component.field.FieldMessage.Severity;
import org.teamapps.ux.component.field.FieldMessage.Visibility;

public class ValidationMessage  {

    public static ValidationMessage info(String propertyName, String message) {
        return new ValidationMessage(propertyName, Severity.INFO, message);
    }

    public static ValidationMessage warning(String propertyName, String message) {
        return new ValidationMessage(propertyName, Severity.WARNING, message);
    }

    public static ValidationMessage error(String propertyName, String message) {
        return new ValidationMessage(propertyName, Severity.ERROR, message);
    }

    public static ValidationMessage success(String propertyName, String message) {
        return new ValidationMessage(propertyName, Severity.SUCCESS, message);
    }

    private final String propertyName;
    private final FieldMessage fieldMessage;


    public ValidationMessage(String propertyName, Severity severity, String message) {
        this.propertyName = propertyName;
        this.fieldMessage = new FieldMessage(severity, message);
    }

    public ValidationMessage(String propertyName, Position position, Visibility visibility, Severity severity, String message) {
        this.propertyName = propertyName;
        this.fieldMessage = new FieldMessage(position, visibility, severity, message);
    }

    public String getPropertyName() {
        return propertyName;
    }

    public FieldMessage getFieldMessage() {
        return fieldMessage;
    }
}
