/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.apache.commons.lang3.StringUtils;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiTextField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;

public class TextField
extends AbstractField<String>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    private int maxCharacters;
    private boolean showClearButton;
    private String emptyText;
    private boolean autofill = false;

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public TextField setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
        this.queueCommandIfRendered(() -> new UiTextField.SetMaxCharactersCommand(this.getId(), maxCharacters));
        return this;
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public TextField setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        this.queueCommandIfRendered(() -> new UiTextField.SetShowClearButtonCommand(this.getId(), showClearButton));
        return this;
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public TextField setEmptyText(String emptyText) {
        this.emptyText = emptyText;
        this.queueCommandIfRendered(() -> new UiTextField.SetEmptyTextCommand(this.getId(), emptyText));
        return this;
    }

    public boolean isAutofill() {
        return this.autofill;
    }

    public void setAutofill(boolean autofill) {
        this.autofill = autofill;
    }

    public UiField createUiComponent() {
        UiTextField uiField = new UiTextField();
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setMaxCharacters(this.maxCharacters);
        uiField.setShowClearButton(this.showClearButton);
        uiField.setEmptyText(this.emptyText);
        uiField.setAutofill(this.autofill);
        return uiField;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)((CharSequence)this.getValue()));
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

