/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.databinding;

import java.util.Objects;
import java.util.function.Supplier;
import org.teamapps.databinding.DataBindings;
import org.teamapps.databinding.MutableValue;
import org.teamapps.event.Event;

public interface ObservableValue<T> {
    public Event<T> onChanged();

    public T get();

    default public boolean valueEquals(T other) {
        return Objects.equals(this.get(), other);
    }

    default public void bindWritingTo(MutableValue<T> mutableValue) {
        DataBindings.bindOneWay(this, mutableValue);
    }

    public static <T> ObservableValue<T> fromEmptyEvent(Event<?> changeEvent, Supplier<T> provider) {
        return DataBindings.createObservableValueWithEmptyEvent(changeEvent, provider);
    }

    public static <T> ObservableValue<T> fromEvent(Event<T> changeEvent, Supplier<T> provider) {
        return DataBindings.createObservableValue(changeEvent, provider);
    }

    public static <T> ObservableValue<T> fromCachedEventValues(Event<T> changeEvent) {
        return DataBindings.createObservableValue(changeEvent);
    }
}

