/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.charting.forcelayout;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiNetworkLink;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutNode;

public class ForceLayoutLink {
    private final ForceLayoutNode source;
    private final ForceLayoutNode target;
    private float lineWidth = 1.0f;
    private Color lineColor = Color.MATERIAL_GREY_500;
    private String lineDashArray;

    public ForceLayoutLink(ForceLayoutNode source, ForceLayoutNode target) {
        this.source = source;
        this.target = target;
    }

    public UiNetworkLink toUiNetworkLink() {
        UiNetworkLink ui = new UiNetworkLink(this.source.getId(), this.target.getId());
        ui.setLineWidth(this.lineWidth);
        ui.setLineColor(UiUtil.createUiColor(this.lineColor));
        ui.setLineDashArray(this.lineDashArray);
        return ui;
    }

    public ForceLayoutNode getSource() {
        return this.source;
    }

    public ForceLayoutNode getTarget() {
        return this.target;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public String getLineDashArray() {
        return this.lineDashArray;
    }

    public void setLineDashArray(String lineDashArray) {
        this.lineDashArray = lineDashArray;
    }
}

