/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.chat;

import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiChatInput;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.chat.NewChatMessageData;

public class ChatInput
extends AbstractComponent {
    public final Event<NewChatMessageData> onMessageSent = new Event();
    private long maxBytesPerUpload = 5000000L;
    private String uploadUrl = "/upload";
    private Icon defaultAttachmentIcon = MaterialIcon.ATTACHMENT;
    private int messageLengthLimit = 10000;

    public UiChatInput createUiComponent() {
        UiChatInput uiChatInput = new UiChatInput(this.getSessionContext().resolveIcon(this.defaultAttachmentIcon));
        this.mapAbstractUiComponentProperties((UiComponent)uiChatInput);
        uiChatInput.setMaxBytesPerUpload(this.maxBytesPerUpload);
        uiChatInput.setUploadUrl(this.uploadUrl);
        uiChatInput.setMessageLengthLimit(this.messageLengthLimit);
        return uiChatInput;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_CHAT_INPUT_MESSAGE_SENT: {
                UiChatInput.MessageSentEvent messageSentEvent = (UiChatInput.MessageSentEvent)event;
                String text = messageSentEvent.getMessage().getText();
                if (this.messageLengthLimit > 0 && text.length() > this.messageLengthLimit) {
                    text = text.substring(0, this.messageLengthLimit);
                }
                List<NewChatMessageData.UploadedFile> uploadedFiles = messageSentEvent.getMessage().getUploadedFiles().stream().map(uiFile -> new NewChatMessageData.UploadedFile(uiFile.getUploadedFileUuid(), uiFile.getFileName())).collect(Collectors.toList());
                NewChatMessageData newChatMessageData = new NewChatMessageData(text, uploadedFiles);
                this.onMessageSent.fire(newChatMessageData);
                break;
            }
            case UI_CHAT_INPUT_UPLOAD_TOO_LARGE: {
                break;
            }
            case UI_CHAT_INPUT_UPLOAD_STARTED: {
                break;
            }
            case UI_CHAT_INPUT_UPLOAD_CANCELED: {
                break;
            }
            case UI_CHAT_INPUT_UPLOAD_FAILED: {
                break;
            }
        }
    }

    @Override
    protected void doDestroy() {
    }

    public long getMaxBytesPerUpload() {
        return this.maxBytesPerUpload;
    }

    public void setMaxBytesPerUpload(long maxBytesPerUpload) {
        this.maxBytesPerUpload = maxBytesPerUpload;
        this.reRenderIfRendered();
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        this.reRenderIfRendered();
    }

    public Icon getDefaultAttachmentIcon() {
        return this.defaultAttachmentIcon;
    }

    public void setDefaultAttachmentIcon(Icon defaultAttachmentIcon) {
        this.defaultAttachmentIcon = defaultAttachmentIcon;
    }

    public int getMessageLengthLimit() {
        return this.messageLengthLimit;
    }

    public void setMessageLengthLimit(int messageLengthLimit) {
        this.messageLengthLimit = messageLengthLimit;
    }
}

