/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiNumberField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.NumberFieldSliderMode;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;

public class NumberField
extends AbstractField<Number>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    private int precision;
    private String emptyText;
    private boolean showClearButton;
    private double minValue = -2.147483648E9;
    private double maxValue = 2.147483647E9;
    private NumberFieldSliderMode sliderMode = NumberFieldSliderMode.DISABLED;
    private double sliderStep = 1.0;
    private boolean commitOnSliderChange = true;

    public NumberField(int precision) {
        this.precision = precision;
    }

    public UiField createUiComponent() {
        UiNumberField field = new UiNumberField();
        this.mapAbstractFieldAttributesToUiField((UiField)field);
        field.setPrecision(this.precision);
        field.setEmptyText(this.emptyText);
        field.setShowClearButton(this.showClearButton);
        field.setMinValue(this.minValue);
        field.setMaxValue(this.maxValue);
        field.setSliderMode(this.sliderMode.toUiNumberFieldSliderMode());
        field.setSliderStep(this.sliderStep);
        field.setCommitOnSliderChange(this.commitOnSliderChange);
        return field;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    @Override
    protected void doDestroy() {
    }

    public int getPrecision() {
        return this.precision;
    }

    public NumberField setPrecision(int precision) {
        this.precision = precision;
        this.queueCommandIfRendered(() -> new UiNumberField.SetPrecisionCommand(this.getId(), precision));
        return this;
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public NumberField setEmptyText(String emptyText) {
        this.emptyText = emptyText;
        this.queueCommandIfRendered(() -> new UiNumberField.SetEmptyTextCommand(this.getId(), emptyText));
        return this;
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public NumberField setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        this.queueCommandIfRendered(() -> new UiNumberField.SetShowClearButtonCommand(this.getId(), showClearButton));
        return this;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public NumberField setMinValue(double minValue) {
        this.minValue = minValue;
        this.queueCommandIfRendered(() -> new UiNumberField.SetMinValueCommand(this.getId(), minValue));
        return this;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public NumberField setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.queueCommandIfRendered(() -> new UiNumberField.SetMaxValueCommand(this.getId(), maxValue));
        return this;
    }

    public NumberFieldSliderMode getSliderMode() {
        return this.sliderMode;
    }

    public NumberField setSliderMode(NumberFieldSliderMode sliderMode) {
        this.sliderMode = sliderMode;
        this.queueCommandIfRendered(() -> new UiNumberField.SetSliderModeCommand(this.getId(), sliderMode.toUiNumberFieldSliderMode()));
        return this;
    }

    public double getSliderStep() {
        return this.sliderStep;
    }

    public NumberField setSliderStep(double sliderStep) {
        this.sliderStep = sliderStep;
        this.queueCommandIfRendered(() -> new UiNumberField.SetSliderStepCommand(this.getId(), sliderStep));
        return this;
    }

    public boolean isCommitOnSliderChange() {
        return this.commitOnSliderChange;
    }

    public NumberField setCommitOnSliderChange(boolean commitOnSliderChange) {
        this.commitOnSliderChange = commitOnSliderChange;
        this.queueCommandIfRendered(() -> new UiNumberField.SetCommitOnSliderChangeCommand(this.getId(), commitOnSliderChange));
        return this;
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

