/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiWorkSpaceLayout;
import org.teamapps.dto.UiWorkSpaceLayoutItem;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.progress.DefaultMultiProgressDisplay;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.component.splitpane.SplitSizePolicy;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.workspacelayout.ChildWindowClosedEventData;
import org.teamapps.ux.component.workspacelayout.LayoutApplyer;
import org.teamapps.ux.component.workspacelayout.ViewGroupPanelState;
import org.teamapps.ux.component.workspacelayout.ViewSelectedEventData;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutItem;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutSplitPane;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutView;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutViewGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public class WorkSpaceLayout
extends AbstractComponent
implements Container {
    public static String ROOT_WINDOW_ID = "ROOT_WINDOW";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkSpaceLayout.class);
    public final Event<ViewSelectedEventData> onViewSelected = new Event();
    public final Event<WorkSpaceLayoutView> onChildWindowCreationFailed = new Event();
    public final Event<ChildWindowClosedEventData> onChildWindowClosed = new Event();
    public final Event<WorkSpaceLayoutView> onViewClosed = new Event();
    public final Event<WorkSpaceLayoutViewGroup> onViewGroupPanelStateChanged = new Event();
    private String childWindowPageTitle = "Application window";
    private Toolbar toolbar;
    private String newWindowBackgroundImage;
    private String newWindowBlurredBackgroundImage;
    private MultiProgressDisplay multiProgressDisplay = new DefaultMultiProgressDisplay();
    private Map<String, WorkSpaceLayoutItem> rootItemsByWindowId = new HashMap<String, WorkSpaceLayoutItem>();

    public WorkSpaceLayout(LayoutItemDefinition layoutDefinition) {
        WorkSpaceLayoutItem rootItem = layoutDefinition.createHeavyWeightItem(this);
        this.setMainRootItem(rootItem);
    }

    public WorkSpaceLayout() {
        this.setMainRootItem(new WorkSpaceLayoutViewGroup(this));
    }

    protected void setMainRootItem(WorkSpaceLayoutItem item) {
        this.rootItemsByWindowId.put(ROOT_WINDOW_ID, item);
        this.updateClientSideLayout(item.getAllViews());
    }

    public WorkSpaceLayoutItem getMainRootItem() {
        return this.rootItemsByWindowId.get(ROOT_WINDOW_ID);
    }

    public void applyLayoutDefinition(LayoutItemDefinition layoutDefinition) {
        this.rootItemsByWindowId = new LayoutApplyer(this).applyFromLayoutDefinition(this.rootItemsByWindowId, Collections.singletonMap(ROOT_WINDOW_ID, layoutDefinition));
        this.updateClientSideLayout(Collections.emptyList());
    }

    public LayoutItemDefinition extractLayoutDefinition() {
        return this.getMainRootItem().createLayoutDefinitionItem();
    }

    private void updateClientSideLayout(List<WorkSpaceLayoutView> newViews) {
        this.queueCommandIfRendered(() -> {
            Map<String, UiWorkSpaceLayoutItem> uiRootItemsByWindowId = this.rootItemsByWindowId.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((WorkSpaceLayoutItem)entry.getValue()).createUiItem()));
            List newUiViews = newViews.stream().map(WorkSpaceLayoutView::createUiView).collect(Collectors.toList());
            return new UiWorkSpaceLayout.RedefineLayoutCommand(this.getId(), uiRootItemsByWindowId, newUiViews);
        });
    }

    @Override
    public UiComponent createUiComponent() {
        UiWorkSpaceLayoutItem uiInitialLayout = this.getMainRootItem().createUiItem();
        List uiViews = this.getMainRootItem().getAllViews().stream().map(WorkSpaceLayoutView::createUiView).collect(Collectors.toList());
        UiWorkSpaceLayout uiLayout = new UiWorkSpaceLayout(uiViews, uiInitialLayout, this.childWindowPageTitle);
        this.mapAbstractUiComponentProperties((UiComponent)uiLayout);
        if (this.toolbar != null) {
            uiLayout.setToolbar(this.toolbar.createUiReference());
        }
        uiLayout.setNewWindowBackgroundImage(this.newWindowBackgroundImage);
        uiLayout.setNewWindowBlurredBackgroundImage(this.newWindowBlurredBackgroundImage);
        uiLayout.setMultiProgressDisplay(Component.createUiClientObjectReference(this.multiProgressDisplay));
        return uiLayout;
    }

    @Override
    protected void doDestroy() {
        this.rootItemsByWindowId.forEach((s, workSpaceLayoutItem) -> workSpaceLayoutItem.getAllViews().forEach(view -> view.destroy()));
        if (this.toolbar != null) {
            this.toolbar.destroy();
        }
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_WORK_SPACE_LAYOUT_LAYOUT_CHANGED: {
                UiWorkSpaceLayout.LayoutChangedEvent layoutChangedEvent = (UiWorkSpaceLayout.LayoutChangedEvent)event;
                this.rootItemsByWindowId = new LayoutApplyer(this).applyFromUiLayoutDescriptor(this.rootItemsByWindowId, layoutChangedEvent.getLayoutsByWindowId());
                this.printLayoutSyncTraceMessage(layoutChangedEvent.getLayoutsByWindowId());
                break;
            }
            case UI_WORK_SPACE_LAYOUT_VIEW_DRAGGED_TO_NEW_WINDOW: {
                UiWorkSpaceLayout.ViewDraggedToNewWindowEvent newWindowEvent = (UiWorkSpaceLayout.ViewDraggedToNewWindowEvent)event;
                Map newLayoutsByWindowId = newWindowEvent.getLayoutsByWindowId();
                this.rootItemsByWindowId = new LayoutApplyer(this).applyFromUiLayoutDescriptor(this.rootItemsByWindowId, newLayoutsByWindowId);
                this.printLayoutSyncTraceMessage(newWindowEvent.getLayoutsByWindowId());
                break;
            }
            case UI_WORK_SPACE_LAYOUT_VIEW_NEEDS_REFRESH: {
                UiWorkSpaceLayout.ViewNeedsRefreshEvent needsRefreshEvent = (UiWorkSpaceLayout.ViewNeedsRefreshEvent)event;
                String viewName = needsRefreshEvent.getViewName();
                WorkSpaceLayoutView view = this.getViewById(viewName);
                this.getSessionContext().queueCommand(new UiWorkSpaceLayout.RefreshViewComponentCommand(this.getId(), viewName, view.createUiView().getComponent()));
                break;
            }
            case UI_WORK_SPACE_LAYOUT_CHILD_WINDOW_CREATION_FAILED: {
                UiWorkSpaceLayout.ChildWindowCreationFailedEvent windowCreationFailedEvent = (UiWorkSpaceLayout.ChildWindowCreationFailedEvent)event;
                WorkSpaceLayoutView view = this.getViewById(windowCreationFailedEvent.getViewName());
                if (view == null) break;
                this.onChildWindowCreationFailed.fire(view);
                break;
            }
            case UI_WORK_SPACE_LAYOUT_CHILD_WINDOW_CLOSED: {
                UiWorkSpaceLayout.ChildWindowClosedEvent windowClosedEvent = (UiWorkSpaceLayout.ChildWindowClosedEvent)event;
                WorkSpaceLayoutItem windowRootItem = this.rootItemsByWindowId.remove(windowClosedEvent.getWindowId());
                if (windowRootItem != null) {
                    this.getMainRootItem().getSelfAndAncestors().stream().filter(item -> item instanceof WorkSpaceLayoutViewGroup).map(item -> (WorkSpaceLayoutViewGroup)item).findFirst().ifPresent(viewGroup -> windowRootItem.getAllViews().forEach(viewGroup::addView));
                }
                this.onChildWindowClosed.fire(new ChildWindowClosedEventData(windowClosedEvent.getWindowId(), windowRootItem));
                break;
            }
            case UI_WORK_SPACE_LAYOUT_VIEW_SELECTED: {
                UiWorkSpaceLayout.ViewSelectedEvent tabSelectedEvent = (UiWorkSpaceLayout.ViewSelectedEvent)event;
                WorkSpaceLayoutViewGroup viewGroup2 = this.getViewGroupById(tabSelectedEvent.getViewGroupId());
                if (viewGroup2 == null) break;
                viewGroup2.handleViewSelectedByClient(tabSelectedEvent.getViewName());
                WorkSpaceLayoutView view = this.getViewById(tabSelectedEvent.getViewName());
                this.onViewSelected.fire(new ViewSelectedEventData(viewGroup2, view));
                break;
            }
            case UI_WORK_SPACE_LAYOUT_VIEW_CLOSED: {
                UiWorkSpaceLayout.ViewClosedEvent viewClosedEvent = (UiWorkSpaceLayout.ViewClosedEvent)event;
                WorkSpaceLayoutView view = this.getViewById(viewClosedEvent.getViewName());
                if (view == null) break;
                WorkSpaceLayoutViewGroup viewGroup3 = this.getViewGroupForViewName(viewClosedEvent.getViewName());
                if (viewGroup3 != null) {
                    viewGroup3.removeViewSilently(view);
                }
                this.onViewClosed.fire(view);
                break;
            }
            case UI_WORK_SPACE_LAYOUT_VIEW_GROUP_PANEL_STATE_CHANGED: {
                UiWorkSpaceLayout.ViewGroupPanelStateChangedEvent stateChangedEvent = (UiWorkSpaceLayout.ViewGroupPanelStateChangedEvent)event;
                WorkSpaceLayoutViewGroup viewGroup4 = this.getViewGroupById(stateChangedEvent.getViewGroupId());
                if (viewGroup4 == null) break;
                viewGroup4.setPanelStateSilently(ViewGroupPanelState.valueOf(stateChangedEvent.getPanelState().name()));
                this.onViewGroupPanelStateChanged.fire(viewGroup4);
                break;
            }
        }
    }

    public WorkSpaceLayoutViewGroup getViewGroupById(String itemId) {
        return this.rootItemsByWindowId.values().stream().flatMap(root -> root.getSelfAndAncestors().stream()).filter(item -> Objects.equals(item.getId(), itemId) && item instanceof WorkSpaceLayoutViewGroup).map(item -> (WorkSpaceLayoutViewGroup)item).findAny().orElse(null);
    }

    private WorkSpaceLayoutViewGroup getViewGroupForViewName(String viewName) {
        return this.rootItemsByWindowId.values().stream().flatMap(root -> root.getSelfAndAncestors().stream()).filter(item -> item instanceof WorkSpaceLayoutViewGroup).map(item -> (WorkSpaceLayoutViewGroup)item).filter(viewGroup -> viewGroup.getViews().stream().anyMatch(view -> Objects.equals(view.getId(), viewName))).findAny().orElse(null);
    }

    private void printLayoutSyncTraceMessage(Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId) {
        if (LOGGER.isTraceEnabled()) {
            try {
                LOGGER.trace("---------------------");
                LOGGER.trace(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(layoutsByWindowId));
                LOGGER.trace(this.rootItemsByWindowId.toString());
                LOGGER.trace("/---------------------");
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private WorkSpaceLayoutView getViewById(String viewName) {
        return this.rootItemsByWindowId.values().stream().flatMap(rootItem -> rootItem.getAllViews().stream()).filter(view -> view.getId().equals(viewName)).findFirst().orElse(null);
    }

    public WorkSpaceLayoutView getViewByPanel(Panel panel) {
        return this.rootItemsByWindowId.values().stream().flatMap(rootItem -> rootItem.getAllViews().stream()).filter(view -> view.getPanel().equals(panel)).findFirst().orElse(null);
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
    }

    @Override
    public boolean isChildVisible(Component child) {
        WorkSpaceLayoutView view;
        if (child instanceof Panel && (view = this.getViewByPanel((Panel)child)) != null && view.getViewGroup() != null) {
            return this.isEffectivelyVisible() && view.getViewGroup().getPanelState() != ViewGroupPanelState.MINIMIZED && view.isSelected();
        }
        if (child == this.toolbar) {
            return this.isEffectivelyVisible();
        }
        return false;
    }

    public void setNewWindowBackgroundImage(String newWindowBackgroundImage) {
        this.newWindowBackgroundImage = newWindowBackgroundImage;
    }

    public void setNewWindowBlurredBackgroundImage(String newWindowBlurredBackgroundImage) {
        this.newWindowBlurredBackgroundImage = newWindowBlurredBackgroundImage;
    }

    void handleViewAddedToGroup(WorkSpaceLayoutViewGroup workSpaceLayoutViewGroup, WorkSpaceLayoutView view, boolean selected) {
        this.queueCommandIfRendered(() -> new UiWorkSpaceLayout.AddViewAsTabCommand(this.getId(), view.createUiView(), workSpaceLayoutViewGroup.getId(), selected));
    }

    void handleViewGroupPanelStateChangedViaApi(WorkSpaceLayoutViewGroup viewGroup, ViewGroupPanelState panelState) {
        this.queueCommandIfRendered(() -> new UiWorkSpaceLayout.SetViewGroupPanelStateCommand(this.getId(), viewGroup.getId(), panelState.toUiViewGroupPanelState()));
    }

    void handleViewSelectedViaApi(WorkSpaceLayoutViewGroup viewGroup, WorkSpaceLayoutView workSpaceLayoutView) {
        this.queueCommandIfRendered(() -> new UiWorkSpaceLayout.SelectViewCommand(this.getId(), workSpaceLayoutView.getId()));
    }

    void handleViewRemovedViaApi(WorkSpaceLayoutViewGroup viewGroup, WorkSpaceLayoutView view) {
        if (viewGroup.getViews().isEmpty() && !viewGroup.isPersistent()) {
            this.removeEmptyViewGroupFromItemTree(viewGroup);
        }
        this.updateClientSideLayout(Collections.emptyList());
    }

    void handleViewAttributeChangedViaApi(WorkSpaceLayoutView view) {
        this.queueCommandIfRendered(() -> new UiWorkSpaceLayout.RefreshViewAttributesCommand(this.getId(), view.getId(), this.getSessionContext().resolveIcon(view.getIcon()), view.getTabTitle(), view.isCloseable(), view.isVisible()));
    }

    void handleSplitPaneSizingChanged(SplitSizePolicy sizePolicy, float referenceChildSize) {
        this.updateClientSideLayout(Collections.emptyList());
    }

    private String getWindowIdForViewGroup(WorkSpaceLayoutViewGroup viewGroup) {
        String windowId = this.rootItemsByWindowId.entrySet().stream().filter(entry -> ((WorkSpaceLayoutItem)entry.getValue()).getSelfAndAncestors().contains(viewGroup)).map(Map.Entry::getKey).findFirst().orElse(null);
        if (windowId == null) {
            LOGGER.error("Cannot find windowId for viewGroup " + viewGroup.getId());
        }
        return windowId;
    }

    private void removeEmptyViewGroupFromItemTree(WorkSpaceLayoutViewGroup viewGroup) {
        String windowId = this.getWindowIdForViewGroup(viewGroup);
        WorkSpaceLayoutSplitPane parentSplitPane = this.findParentItem(viewGroup);
        if (parentSplitPane != null) {
            boolean viewGroupIsFirstChild = parentSplitPane.getFirstChild() == viewGroup;
            WorkSpaceLayoutItem siblingItem = viewGroupIsFirstChild ? parentSplitPane.getLastChild() : parentSplitPane.getFirstChild();
            WorkSpaceLayoutSplitPane grandParentSplitPane = this.findParentItem(parentSplitPane);
            if (grandParentSplitPane != null) {
                boolean parentSplitPaneIsFirstChild;
                boolean bl = parentSplitPaneIsFirstChild = grandParentSplitPane.getFirstChild() == parentSplitPane;
                if (parentSplitPaneIsFirstChild) {
                    grandParentSplitPane.setFirstChild(siblingItem);
                } else {
                    grandParentSplitPane.setLastChild(siblingItem);
                }
            } else {
                this.rootItemsByWindowId.put(windowId, siblingItem);
            }
            viewGroup.handleRemoved();
            parentSplitPane.handleRemoved();
        }
    }

    private WorkSpaceLayoutSplitPane findParentItem(WorkSpaceLayoutItem child) {
        return this.rootItemsByWindowId.values().stream().flatMap(rootItem -> rootItem.getSelfAndAncestors().stream()).filter(item -> item instanceof WorkSpaceLayoutSplitPane).map(item -> (WorkSpaceLayoutSplitPane)item).filter(splitPane -> splitPane.getFirstChild() == child || splitPane.getLastChild() == child).findFirst().orElse(null);
    }

    public void setMultiProgressDisplay(MultiProgressDisplay multiProgressDisplay) {
        this.multiProgressDisplay = multiProgressDisplay;
        this.queueCommandIfRendered(() -> new UiWorkSpaceLayout.SetMultiProgressDisplayCommand(this.getId(), multiProgressDisplay.createUiReference()));
    }

    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.multiProgressDisplay;
    }
}

