/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value.filter;

import org.teamapps.data.value.DataRecord;
import org.teamapps.data.value.filter.AbstractFilter;
import org.teamapps.data.value.filter.FilterType;

public class NumericRangeFilter
extends AbstractFilter {
    private final Double start;
    private final Double end;
    private final Comparator comparator;

    public NumericRangeFilter(String property, Double start, Double end, Comparator comparator) {
        super(property);
        this.start = start;
        this.end = end;
        this.comparator = comparator;
    }

    @Override
    public FilterType getType() {
        return FilterType.NUMERIC_RANGE;
    }

    @Override
    public boolean matches(DataRecord record, boolean treatNullAsDefaultValue) {
        Number recordValue = (Number)record.getValue(this.getProperty());
        double value = 0.0;
        if (recordValue != null) {
            value = recordValue.doubleValue();
        }
        if (!treatNullAsDefaultValue && recordValue == null) {
            return false;
        }
        switch (this.comparator) {
            case BETWEEN: {
                return value > this.start && value < this.end;
            }
            case BETWEEN_INCLUSIVE: {
                break;
            }
            case OUTSIDE: {
                break;
            }
        }
        return false;
    }

    @Override
    public String explain(int filterLevel) {
        return this.createLevelIndentString(filterLevel) + "NUMERIC-RANGE: " + this.getProperty() + " " + this.comparator.name() + " " + String.format("%1.2f", this.start) + " AND " + String.format("%1.2f", this.end) + "\n";
    }

    public Double getStart() {
        return this.start;
    }

    public Double getEnd() {
        return this.end;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public static enum Comparator {
        BETWEEN,
        BETWEEN_INCLUSIVE,
        OUTSIDE,
        OUTSIDE_INCLUSIVE;

    }
}

