/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.panel;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiElegantPanel;
import org.teamapps.dto.UiEvent;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Spacing;

public class ElegantPanel
extends AbstractComponent {
    private Color bodyBackgroundColor = Color.WHITE.withAlpha(0.4f);
    private AbstractComponent content;
    private HorizontalElementAlignment horizontalContentAlignment = HorizontalElementAlignment.CENTER;
    private Spacing padding = new Spacing(20, 10, 20, 10);
    private int maxContentWidth = 0;

    public ElegantPanel() {
        this(null);
    }

    public ElegantPanel(AbstractComponent content) {
        this.content = content;
    }

    @Override
    public UiComponent createUiComponent() {
        UiElegantPanel uiElegantPanel = new UiElegantPanel();
        this.mapAbstractUiComponentProperties((UiComponent)uiElegantPanel);
        uiElegantPanel.setBodyBackgroundColor(this.bodyBackgroundColor.toHtmlColorString());
        uiElegantPanel.setContent(this.content.createUiReference());
        uiElegantPanel.setMaxContentWidth(this.maxContentWidth);
        uiElegantPanel.setPadding(this.padding.createUiSpacing());
        uiElegantPanel.setHorizontalContentAlignment(this.horizontalContentAlignment.toUiHorizontalElementAlignment());
        return uiElegantPanel;
    }

    @Override
    protected void doDestroy() {
        if (this.content != null) {
            this.content.destroy();
        }
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    public Color getBodyBackgroundColor() {
        return this.bodyBackgroundColor;
    }

    public void setBodyBackgroundColor(Color bodyBackgroundColor) {
        this.bodyBackgroundColor = bodyBackgroundColor;
    }

    public AbstractComponent getContent() {
        return this.content;
    }

    public void setContent(AbstractComponent content) {
        this.content = content;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public void setPadding(Spacing padding) {
        this.padding = padding;
    }

    public int getMaxContentWidth() {
        return this.maxContentWidth;
    }

    public void setMaxContentWidth(int maxContentWidth) {
        this.maxContentWidth = maxContentWidth;
    }

    public HorizontalElementAlignment getHorizontalContentAlignment() {
        return this.horizontalContentAlignment;
    }

    public void setHorizontalContentAlignment(HorizontalElementAlignment horizontalContentAlignment) {
        this.horizontalContentAlignment = horizontalContentAlignment;
    }
}

