/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.teamapps.dto.UiWorkSpaceLayoutItem;
import org.teamapps.dto.UiWorkSpaceLayoutSplitItem;
import org.teamapps.ux.component.splitpane.SplitSizePolicy;
import org.teamapps.ux.component.workspacelayout.SplitDirection;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutItem;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutView;
import org.teamapps.ux.component.workspacelayout.definition.SplitPaneDefinition;

public class WorkSpaceLayoutSplitPane
extends WorkSpaceLayoutItem {
    private final SplitDirection splitDirection;
    private SplitSizePolicy sizePolicy;
    private float referenceChildSize;
    private WorkSpaceLayoutItem firstChild;
    private WorkSpaceLayoutItem lastChild;

    public WorkSpaceLayoutSplitPane(String id, SplitDirection splitDirection, SplitSizePolicy sizePolicy, float referenceChildSize, WorkSpaceLayout workSpaceLayout) {
        this(id, splitDirection, sizePolicy, referenceChildSize, null, null, workSpaceLayout);
    }

    public WorkSpaceLayoutSplitPane(SplitDirection splitDirection, SplitSizePolicy sizePolicy, float referenceChildSize, WorkSpaceLayout workSpaceLayout) {
        this(splitDirection, sizePolicy, referenceChildSize, null, null, workSpaceLayout);
    }

    public WorkSpaceLayoutSplitPane(SplitDirection splitDirection, SplitSizePolicy sizePolicy, float referenceChildSize, WorkSpaceLayoutItem firstChild, WorkSpaceLayoutItem lastChild, WorkSpaceLayout workSpaceLayout) {
        this(null, splitDirection, sizePolicy, referenceChildSize, firstChild, lastChild, workSpaceLayout);
    }

    public WorkSpaceLayoutSplitPane(String id, SplitDirection splitDirection, SplitSizePolicy sizePolicy, float referenceChildSize, WorkSpaceLayoutItem firstChild, WorkSpaceLayoutItem lastChild, WorkSpaceLayout workSpaceLayout) {
        super(id != null ? id : UUID.randomUUID().toString(), workSpaceLayout);
        this.splitDirection = splitDirection;
        this.firstChild = firstChild;
        if (this.firstChild != null) {
            this.firstChild.setParent(this);
        }
        this.lastChild = lastChild;
        if (this.lastChild != null) {
            this.lastChild.setParent(this);
        }
        this.sizePolicy = sizePolicy;
        this.referenceChildSize = referenceChildSize;
    }

    @Override
    public List<WorkSpaceLayoutView> getAllViews() {
        ArrayList<WorkSpaceLayoutView> allViews = new ArrayList<WorkSpaceLayoutView>();
        if (this.firstChild != null) {
            allViews.addAll(this.firstChild.getAllViews());
        }
        if (this.lastChild != null) {
            allViews.addAll(this.lastChild.getAllViews());
        }
        return allViews;
    }

    @Override
    public List<WorkSpaceLayoutItem> getSelfAndAncestors() {
        ArrayList<WorkSpaceLayoutItem> result = new ArrayList<WorkSpaceLayoutItem>();
        result.add(this);
        if (this.firstChild != null) {
            result.addAll(this.firstChild.getSelfAndAncestors());
        }
        if (this.lastChild != null) {
            result.addAll(this.lastChild.getSelfAndAncestors());
        }
        return result;
    }

    @Override
    public UiWorkSpaceLayoutItem createUiItem() {
        UiWorkSpaceLayoutSplitItem item = new UiWorkSpaceLayoutSplitItem(this.getId(), this.splitDirection.toUiSplitDirection(), this.firstChild != null ? this.firstChild.createUiItem() : null, this.lastChild != null ? this.lastChild.createUiItem() : null);
        item.setSizePolicy(this.sizePolicy.toUiSplitSizePolicy());
        item.setReferenceChildSize(this.referenceChildSize);
        return item;
    }

    @Override
    public SplitPaneDefinition createLayoutDefinitionItem() {
        return new SplitPaneDefinition(this.getId(), this.splitDirection, this.sizePolicy, this.referenceChildSize, this.firstChild.createLayoutDefinitionItem(), this.lastChild.createLayoutDefinitionItem());
    }

    @Override
    protected void callHandleRemovedOnChildren() {
        if (this.firstChild != null) {
            this.firstChild.handleRemoved();
        }
        if (this.lastChild != null) {
            this.lastChild.handleRemoved();
        }
    }

    public SplitDirection getSplitDirection() {
        return this.splitDirection;
    }

    public WorkSpaceLayoutItem getFirstChild() {
        return this.firstChild;
    }

    public WorkSpaceLayoutSplitPane setFirstChild(WorkSpaceLayoutItem firstChild) {
        this.firstChild = firstChild;
        if (this.firstChild != null) {
            this.firstChild.setParent(this);
        }
        return this;
    }

    public WorkSpaceLayoutItem getLastChild() {
        return this.lastChild;
    }

    public WorkSpaceLayoutSplitPane setLastChild(WorkSpaceLayoutItem lastChild) {
        this.lastChild = lastChild;
        if (this.lastChild != null) {
            this.lastChild.setParent(this);
        }
        return this;
    }

    public WorkSpaceLayoutSplitPane setChildren(WorkSpaceLayoutItem firstChild, WorkSpaceLayoutItem lastChild) {
        this.firstChild = firstChild;
        if (this.firstChild != null) {
            this.firstChild.setParent(this);
        }
        this.lastChild = lastChild;
        if (this.lastChild != null) {
            this.lastChild.setParent(this);
        }
        return this;
    }

    public SplitSizePolicy getSizePolicy() {
        return this.sizePolicy;
    }

    public void setSizePolicy(SplitSizePolicy sizePolicy) {
        this.sizePolicy = sizePolicy;
        if (this.getWorkSpaceLayout() != null) {
            this.getWorkSpaceLayout().handleSplitPaneSizingChanged(sizePolicy, this.referenceChildSize);
        }
    }

    public float getReferenceChildSize() {
        return this.referenceChildSize;
    }

    public void setReferenceChildSize(float referenceChildSize) {
        this.referenceChildSize = referenceChildSize;
        if (this.getWorkSpaceLayout() != null) {
            this.getWorkSpaceLayout().handleSplitPaneSizingChanged(this.sizePolicy, referenceChildSize);
        }
    }

    public void setSizing(SplitSizePolicy sizePolicy, float referenceChildSize) {
        this.sizePolicy = sizePolicy;
        this.referenceChildSize = referenceChildSize;
        if (this.getWorkSpaceLayout() != null) {
            this.getWorkSpaceLayout().handleSplitPaneSizingChanged(sizePolicy, referenceChildSize);
        }
    }

    public String toString() {
        return "WorkSpaceLayoutSplitPane{\n \"id\" : '" + this.getId() + "',\n \"splitDirection\" : " + this.splitDirection + ",\n \"sizePolicy\" : " + this.sizePolicy + ",\n \"referenceChildSize\" : " + this.referenceChildSize + ",\n \"firstChild\" : " + (this.firstChild != null ? this.firstChild.toString().replace("\n", "\n ") : null) + ",\n \"lastChild\" : " + (this.lastChild != null ? this.lastChild.toString().replace("\n", "\n ") : null) + "\n}";
    }

    void setSizePolicySilently(SplitSizePolicy sizePolicy) {
        this.sizePolicy = sizePolicy;
    }

    void setReferenceChildSizeSilently(float referenceChildSize) {
        this.referenceChildSize = referenceChildSize;
    }

    void setFirstChildSilently(WorkSpaceLayoutItem item) {
        this.firstChild = item;
        if (this.firstChild != null) {
            this.firstChild.setParent(this);
        }
    }

    void setLastChildSilently(WorkSpaceLayoutItem item) {
        this.lastChild = item;
        if (this.lastChild != null) {
            this.lastChild.setParent(this);
        }
    }
}

