/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.tabpanel;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiTabPanel;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.tabpanel.Tab;
import org.teamapps.ux.component.tabpanel.TabPanelTabStyle;
import org.teamapps.ux.component.toolbutton.ToolButton;

public class TabPanel
extends AbstractComponent
implements Container {
    public final Event<Tab> onTabSelected = new Event();
    public final Event<Tab> onTabClosed = new Event();
    private final List<Tab> tabs = new ArrayList<Tab>();
    private Tab selectedTab;
    private List<ToolButton> toolButtons = new ArrayList<ToolButton>();
    private boolean hideTabBarIfSingleTab = false;
    private TabPanelTabStyle tabStyle = TabPanelTabStyle.BLOCKS;

    public TabPanel() {
    }

    public TabPanel(List<Tab> tabs) {
        this.tabs.clear();
        this.tabs.addAll(tabs);
        tabs.forEach(tab -> tab.setTabPanel(this));
    }

    public void addTab(Tab tab) {
        this.addTab(tab, false);
    }

    public void addTab(Tab tab, boolean select) {
        if (select || this.tabs.isEmpty()) {
            this.selectedTab = tab;
        }
        this.tabs.add(tab);
        tab.setTabPanel(this);
        this.queueCommandIfRendered(() -> new UiTabPanel.AddTabCommand(this.getId(), tab.createUiTab(), select));
    }

    public void removeTab(Tab tab) {
        boolean wasRemoved = this.tabs.remove(tab);
        if (wasRemoved) {
            this.queueCommandIfRendered(() -> new UiTabPanel.RemoveTabCommand(this.getId(), tab.getClientId()));
        }
    }

    public void setSelectedTab(Tab tab) {
        if (tab != null) {
            this.selectedTab = tab;
            this.queueCommandIfRendered(() -> new UiTabPanel.SelectTabCommand(this.getId(), tab.getClientId()));
        }
    }

    public Tab getSelectedTab() {
        return this.selectedTab;
    }

    public List<Tab> getTabs() {
        return new ArrayList<Tab>(this.tabs);
    }

    public void addToolButton(ToolButton toolButton) {
        this.toolButtons.add(toolButton);
        toolButton.setParent(this);
        this.updateToolButtons();
    }

    public void removeToolButton(ToolButton toolButton) {
        this.toolButtons.remove(toolButton);
        toolButton.setParent(null);
        this.updateToolButtons();
    }

    public void setToolButtons(List<ToolButton> toolButtons) {
        this.toolButtons.clear();
        if (toolButtons != null) {
            this.toolButtons.addAll(toolButtons);
            this.toolButtons.forEach(toolButton -> toolButton.setParent(this));
        }
        this.updateToolButtons();
    }

    private void updateToolButtons() {
        this.queueCommandIfRendered(() -> new UiTabPanel.SetToolButtonsCommand(this.getId(), this.toolButtons.stream().map(toolButton -> toolButton.createUiReference()).collect(Collectors.toList())));
    }

    public List<ToolButton> getToolButtons() {
        return this.toolButtons;
    }

    public boolean isHideTabBarIfSingleTab() {
        return this.hideTabBarIfSingleTab;
    }

    public void setHideTabBarIfSingleTab(boolean hideTabBarIfSingleTab) {
        this.hideTabBarIfSingleTab = hideTabBarIfSingleTab;
        this.queueCommandIfRendered(() -> new UiTabPanel.SetHideTabBarIfSingleTabCommand(this.getId(), hideTabBarIfSingleTab));
    }

    public TabPanelTabStyle getTabStyle() {
        return this.tabStyle;
    }

    public void setTabStyle(TabPanelTabStyle tabStyle) {
        this.tabStyle = tabStyle;
        this.queueCommandIfRendered(() -> new UiTabPanel.SetTabStyleCommand(this.getId(), tabStyle.toUiTabPanelTabStyle()));
    }

    @Override
    public UiComponent createUiComponent() {
        UiTabPanel uiTabPanel = new UiTabPanel();
        this.mapAbstractUiComponentProperties((UiComponent)uiTabPanel);
        List uiTabs = this.tabs.stream().map(tab -> tab != null ? tab.createUiTab() : null).collect(Collectors.toList());
        uiTabPanel.setTabs(uiTabs);
        uiTabPanel.setSelectedTabId(this.getSelectedTab() != null ? this.getSelectedTab().getClientId() : null);
        uiTabPanel.setHideTabBarIfSingleTab(this.hideTabBarIfSingleTab);
        uiTabPanel.setTabStyle(this.tabStyle.toUiTabPanelTabStyle());
        uiTabPanel.setToolButtons(this.toolButtons.stream().map(toolButton -> toolButton.createUiReference()).collect(Collectors.toList()));
        return uiTabPanel;
    }

    @Override
    protected void doDestroy() {
        this.tabs.forEach(Tab::destroy);
    }

    private Tab getTabByClientId(String tabId) {
        return this.tabs.stream().filter(tab -> Objects.equals(tab.getClientId(), tabId)).findFirst().orElse(null);
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TAB_PANEL_TAB_SELECTED: {
                UiTabPanel.TabSelectedEvent tabSelectedEvent = (UiTabPanel.TabSelectedEvent)event;
                if (tabSelectedEvent.getTabId() == null) {
                    this.selectedTab = null;
                } else {
                    Tab selectedTab;
                    Tab oldSelectedTab = this.selectedTab;
                    this.selectedTab = selectedTab = this.getTabByClientId(tabSelectedEvent.getTabId());
                    oldSelectedTab.onDeselected.fire(null);
                    selectedTab.onSelected.fire(null);
                }
                this.onTabSelected.fire(this.selectedTab);
                break;
            }
            case UI_TAB_PANEL_TAB_NEEDS_REFRESH: {
                UiTabPanel.TabNeedsRefreshEvent tabNeedsRefreshEvent = (UiTabPanel.TabNeedsRefreshEvent)event;
                Tab tab = this.getTabByClientId(tabNeedsRefreshEvent.getTabId());
                this.queueCommandIfRendered(() -> new UiTabPanel.SetTabContentCommand(this.getId(), tab.getClientId(), Component.createUiClientObjectReference(tab.getContent())));
                break;
            }
            case UI_TAB_PANEL_TAB_CLOSED: {
                UiTabPanel.TabClosedEvent tabClosedEvent = (UiTabPanel.TabClosedEvent)event;
                String tabId = tabClosedEvent.getTabId();
                Tab closedTab = this.getTabByClientId(tabId);
                if (closedTab == null) break;
                this.tabs.remove(closedTab);
                closedTab.onClosed.fire(null);
                this.onTabClosed.fire(closedTab);
            }
        }
    }

    void handleTabSelected(Tab tab) {
        this.setSelectedTab(tab);
    }

    void handleTabToolbarChanged(Tab tab) {
        this.queueCommandIfRendered(() -> new UiTabPanel.SetTabToolbarCommand(this.getId(), tab.getClientId(), Component.createUiClientObjectReference(tab.getToolbar())));
    }

    void handleTabContentChanged(Tab tab) {
        this.queueCommandIfRendered(() -> new UiTabPanel.SetTabContentCommand(this.getId(), tab.getClientId(), Component.createUiClientObjectReference(tab.getContent())));
    }

    void handleTabConfigurationChanged(Tab tab) {
        String iconString = this.getSessionContext().resolveIcon(tab.getIcon());
        String caption = tab.getTitle();
        this.queueCommandIfRendered(() -> new UiTabPanel.SetTabConfigurationCommand(this.getId(), tab.getClientId(), iconString, caption, tab.isCloseable(), tab.isVisible(), tab.isRightSide()));
    }

    void handleTabVisibilityChanged(Tab tab) {
        String iconString = this.getSessionContext().resolveIcon(tab.getIcon());
        String caption = tab.getTitle();
        this.queueCommandIfRendered(() -> new UiTabPanel.SetTabConfigurationCommand(this.getId(), tab.getClientId(), iconString, caption, tab.isCloseable(), tab.isVisible(), tab.isRightSide()));
    }

    @Override
    public boolean isChildVisible(Component child) {
        boolean isActiveTab = this.getSelectedTab() != null && this.getSelectedTab().getContent() == child;
        boolean isToolButton = this.toolButtons.contains(child);
        return this.isEffectivelyVisible() && (isActiveTab || isToolButton);
    }
}

