/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.application.data.RecordDeletableDecider;
import org.teamapps.ux.application.data.RecordDeletionHandler;
import org.teamapps.ux.application.data.RecordEditableDecider;
import org.teamapps.ux.application.data.RecordHandler;
import org.teamapps.ux.application.data.RecordUpdateHandler;
import org.teamapps.ux.application.data.RecordValidator;
import org.teamapps.ux.application.data.UpdateMode;
import org.teamapps.ux.application.filter.FilterProvider;
import org.teamapps.ux.application.validation.RecordChangeSet;
import org.teamapps.ux.application.validation.ValidationResult;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class TableRecordHandler<RECORD> {
    public Event<RECORD> onRecordSaved = new Event();
    public Event<RECORD> onRecordSavingFailed = new Event();
    private final Table<RECORD> table;
    private UpdateMode updateMode = UpdateMode.NOT_EDITABLE;
    private boolean emptyRecordsOnTop;
    private boolean ensureEmptyRecordRow;
    private RecordEditableDecider<RECORD> recordEditableDecider;
    private RecordDeletableDecider<RECORD> recordDeletableDecider;
    private RecordValidator<RECORD> recordValidator;
    private RecordUpdateHandler<RECORD> recordUpdateHandler;
    private RecordDeletionHandler<RECORD> recordDeletionHandler;
    private Supplier<RECORD> emptyRecordSupplier;
    private FilterProvider<RECORD> filterProvider;
    private Set<RECORD> uncommittedEmptyRecords = new HashSet<RECORD>();
    private RECORD previouslySelectedRecord;
    private String previouslyUpdatedProperty;
    private ToolbarButton buttonAdd;
    private ToolbarButton buttonSave;
    private ToolbarButton buttonDiscardChanges;
    private ToolbarButton buttonDelete;
    private ToolbarButton buttonMultiDeleteRecord;
    private ToolbarButton buttonDisplayedColumns;
    private ToolbarButton buttonColumnWidth;
    private ToolbarButton buttonFilter;
    private ToolbarButton buttonOptions;
    private SessionContext context;

    protected TableRecordHandler(Table<RECORD> table, UpdateMode updateMode, boolean emptyRecordsOnTop, boolean ensureEmptyRecordRow, RecordEditableDecider<RECORD> recordEditableDecider, RecordDeletableDecider<RECORD> recordDeletableDecider, RecordValidator<RECORD> recordValidator, RecordUpdateHandler<RECORD> recordUpdateHandler, RecordDeletionHandler<RECORD> recordDeletionHandler, RecordHandler<RECORD> recordHandler, Supplier<RECORD> emptyRecordSupplier, FilterProvider<RECORD> filterProvider, View view) {
        this.table = table;
        this.updateMode = updateMode;
        this.filterProvider = filterProvider;
        this.emptyRecordsOnTop = emptyRecordsOnTop;
        this.emptyRecordSupplier = emptyRecordSupplier;
        this.setEnsureEmptyRecordRow(ensureEmptyRecordRow);
        this.recordEditableDecider = recordEditableDecider;
        this.recordDeletableDecider = recordDeletableDecider;
        this.recordValidator = recordValidator;
        this.recordUpdateHandler = recordUpdateHandler;
        this.recordDeletionHandler = recordDeletionHandler;
        if (recordHandler != null) {
            this.setRecordHandler(recordHandler);
        }
        this.init();
        if (view != null) {
            this.updateView(view);
        }
    }

    public void setEnsureEmptyRecordRow(boolean ensureEmptyRecordRow) {
        if (this.emptyRecordSupplier == null) {
            return;
        }
        this.ensureEmptyRecordRow = ensureEmptyRecordRow;
        if (ensureEmptyRecordRow) {
            RECORD emptyRecord = this.emptyRecordSupplier.get();
            this.table.addNonModelRecord(emptyRecord, this.emptyRecordsOnTop);
        } else {
            this.table.removeAllNonModelRecords();
        }
    }

    private void setRecordHandler(RecordHandler<RECORD> recordHandler) {
        this.recordEditableDecider = recordHandler;
        this.recordDeletableDecider = recordHandler;
        this.recordValidator = recordHandler;
        this.recordUpdateHandler = recordHandler;
        this.recordDeletionHandler = recordHandler;
    }

    private void init() {
        this.context = CurrentSessionContext.get();
        this.createCRUDButtons();
        this.createTableOptions();
    }

    private void createCRUDButtons() {
        this.buttonAdd = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.ADD_CIRCLE, this.context.getLocalized("dict.add", new Object[0]), this.context.getLocalized("dict.addNewRecord", new Object[0]))).setVisible(false);
        this.buttonSave = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.SAVE, this.context.getLocalized("dict.save", new Object[0]))).setVisible(false);
        this.buttonDiscardChanges = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.UNDO, this.context.getLocalized("dict.discard", new Object[0]))).setVisible(false);
        this.buttonDelete = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.DELETE, this.context.getLocalized("dict.delete", new Object[0]))).setVisible(false);
        this.buttonMultiDeleteRecord = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.DELETE_FOREVER, this.context.getLocalized("dict.deleteAll", new Object[0]))).setVisible(false);
        if (this.emptyRecordSupplier != null) {
            this.buttonAdd.setVisible(true);
            this.buttonAdd.onClick.addListener(toolbarButtonClickEvent -> this.checkEmptyRecordRow());
            this.checkEmptyRecordRow();
        }
        this.table.onCellValueChanged.addListener(fieldChangeEventData -> {
            if (this.updateMode == UpdateMode.NOT_EDITABLE) {
                return;
            }
            Object record = fieldChangeEventData.getRecord();
            String propertyName = fieldChangeEventData.getPropertyName();
            this.table.setCellMarked(record, propertyName, true);
            this.handleRecordChange(record, propertyName, this.updateMode == UpdateMode.AUTO_SAVE_ANY_CELL);
            if (this.updateMode == UpdateMode.SAVE_ON_USER_REQUEST) {
                this.buttonSave.setVisible(true);
                this.buttonDiscardChanges.setVisible(true);
            }
            this.previouslyUpdatedProperty = propertyName;
        });
        this.table.onRowSelected.addListener(record -> {
            this.buttonMultiDeleteRecord.setVisible(false);
            this.buttonDelete.setVisible(this.isRecordDeletable(record));
            if (this.updateMode == UpdateMode.AUTO_SAVE_ON_ROW_CHANGE) {
                List<RECORD> changedRecords = this.table.getRecordsWithChangedCellValues();
                for (RECORD changedRecord : changedRecords) {
                    this.handleRecordChange(changedRecord, null, true);
                }
            }
            this.previouslySelectedRecord = record;
        });
        this.table.onMultipleRowsSelected.addListener(records -> {
            this.buttonDelete.setVisible(false);
            if (records.stream().allMatch(record -> this.isRecordDeletable(record))) {
                this.buttonMultiDeleteRecord.setVisible(true);
            } else {
                this.buttonMultiDeleteRecord.setVisible(false);
            }
        });
        this.buttonDiscardChanges.onClick.addListener(toolbarButtonClickEvent -> {
            this.table.clearChangeBuffer();
            this.table.clearAllCellMarkings();
            this.table.refreshData();
            this.buttonSave.setVisible(false);
            this.buttonDiscardChanges.setVisible(false);
        });
        this.buttonSave.onClick.addListener(toolbarButtonClickEvent -> {
            List<RECORD> changedRecords = this.table.getRecordsWithChangedCellValues();
            for (RECORD record : changedRecords) {
                this.handleRecordChange(record, null, true);
            }
        });
        this.buttonDelete.onClick.addListener(toolbarButtonClickEvent -> {
            this.recordDeletionHandler.deleteRecord(this.table.getSelectedRecord());
            this.table.getModel().onAllDataChanged().fire(null);
        });
        this.buttonMultiDeleteRecord.onClick.addListener(toolbarButtonClickEvent -> {
            if (this.recordDeletableDecider != null) {
                List<RECORD> records = this.table.getSelectedRecords();
                records.forEach(record -> this.recordDeletionHandler.deleteRecord(this.table.getSelectedRecord()));
                this.table.getModel().onAllDataChanged().fire(null);
            }
        });
    }

    private boolean isRecordDeletable(RECORD record) {
        return this.recordDeletableDecider != null && this.recordDeletableDecider.isRecordDeletable(record);
    }

    private void handleRecordChange(RECORD record, String lastUpdatedProperty, boolean saveRecord) {
        RecordChangeSet<RECORD> changeSet = new RecordChangeSet<RECORD>(record, this.table.getChangedCellValues(record));
        if (!changeSet.isChanged()) {
            return;
        }
        ValidationResult validationResult = this.recordValidator.validateRecordUpdate(changeSet);
        if (saveRecord && validationResult.isSuccess()) {
            RECORD updateRecord = this.recordUpdateHandler.updateRecord(changeSet);
            this.table.getModel().onRecordUpdated().fire(updateRecord);
            if (this.uncommittedEmptyRecords.contains(record)) {
                this.uncommittedEmptyRecords.remove(record);
                this.checkEmptyRecordRow();
            }
            this.onRecordSaved.fire(record);
        } else if (saveRecord && !validationResult.isSuccess()) {
            this.onRecordSavingFailed.fire(record);
        }
        this.table.updateRecordMessages(record, validationResult.getFieldMessagesMap());
        if (saveRecord && !validationResult.isSuccess() && lastUpdatedProperty != null) {
            this.table.focusCell(record, lastUpdatedProperty);
        }
    }

    private void checkEmptyRecordRow() {
        if (this.ensureEmptyRecordRow) {
            RECORD emptyRecord = this.emptyRecordSupplier.get();
            this.uncommittedEmptyRecords.add(emptyRecord);
            this.table.addNonModelRecord(emptyRecord, this.emptyRecordsOnTop);
        }
    }

    private void createTableOptions() {
        this.buttonDisplayedColumns = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.columns", new Object[0]))).setVisible(true);
        this.buttonColumnWidth = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.columnWidth", new Object[0]))).setVisible(true);
        this.buttonFilter = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.filter", new Object[0]))).setVisible(true);
        this.buttonOptions = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON_TINY, new BaseTemplateRecord((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.options", new Object[0]))).setVisible(true);
        SimpleItemView itemView = new SimpleItemView();
        this.buttonDisplayedColumns.setDropDownComponent(itemView);
        SimpleItemGroup itemGroup = itemView.addSingleColumnGroup((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.baseSettings", new Object[0]));
        itemGroup.addItem((Icon)MaterialIcon.ADD, (String)this.context.getLocalized((String)"dict.defaultColumns", (Object[])new Object[0]), (String)this.context.getLocalized((String)"dict.displayTheDefaultColumns", (Object[])new Object[0])).onClick.addListener(o -> {});
        itemGroup.addItem((Icon)MaterialIcon.ADD, (String)this.context.getLocalized((String)"dict.allColumns", (Object[])new Object[0]), (String)this.context.getLocalized((String)"dict.displayAllColumns", (Object[])new Object[0])).onClick.addListener(o -> this.table.getColumns().stream().map(TableColumn::getField).forEach(field -> {
            if (!field.isVisible()) {
                field.setVisible(true);
            }
        }));
        itemGroup = itemView.addSingleColumnGroup((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.selectColumnToDisplayOrHide", new Object[0]));
        for (TableColumn column : this.table.getColumns()) {
            itemGroup.addItem((Icon)MaterialIcon.ADD, (String)column.getTitle(), (String)this.context.getLocalized((String)"dict.setVisibilityOfColumn", (Object[])new Object[]{column.getTitle()})).onClick.addListener(o -> column.getField().setVisible(!column.getField().isVisible()));
        }
        itemView = new SimpleItemView();
        this.buttonColumnWidth.setDropDownComponent(itemView);
        itemGroup = itemView.addSingleColumnGroup((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.columnWidth", new Object[0]));
        itemGroup.addItem((Icon)MaterialIcon.ADD, (String)this.context.getLocalized((String)"dict.autoFit", (Object[])new Object[0]), (String)this.context.getLocalized((String)"dict.setAllColumnWidthsToTheWidthOfTheTable", (Object[])new Object[0])).onClick.addListener(o -> this.table.setForceFitWidth(true));
        itemGroup.addItem((Icon)MaterialIcon.ADD, (String)this.context.getLocalized((String)"dict.standardWidth", (Object[])new Object[0]), (String)this.context.getLocalized((String)"dict.setColumnWidthsToTheDefaultWidths", (Object[])new Object[0])).onClick.addListener(o -> this.table.setForceFitWidth(false));
        itemGroup = itemView.addSingleColumnGroup((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.automaticColumnDisplay", new Object[0]));
        itemGroup.addItem((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.hideEmptyColumns", new Object[0]), this.context.getLocalized("dict.hideAllColumnsThatDoNotContainAnyData", new Object[0]));
        itemGroup.addItem((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.displayEmptyColumns", new Object[0]), this.context.getLocalized("dict.displayAllColumnsEventEmptyOnes", new Object[0]));
        itemGroup = itemView.addSingleColumnGroup((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.changeWidth", new Object[0]));
        itemGroup.addItem((Icon)MaterialIcon.ADD, (String)this.context.getLocalized((String)"dict.decreaseColumnWidths", (Object[])new Object[0]), (String)this.context.getLocalized((String)"dict.decreaseTheWidthsOfAllColumns", (Object[])new Object[0])).onClick.addListener(o -> {
            for (TableColumn<RECORD> column : this.table.getColumns()) {
                column.setDefaultWidth((int)((double)column.getDefaultWidth() / 1.5));
            }
            if (this.table.isForceFitWidth()) {
                this.table.setForceFitWidth(false);
            } else {
                this.table.reRenderIfRendered();
            }
        });
        itemGroup.addItem((Icon)MaterialIcon.ADD, (String)this.context.getLocalized((String)"dict.increaseColumnWidths", (Object[])new Object[0]), (String)this.context.getLocalized((String)"dict.increaseTheWidthsOfAllColumns", (Object[])new Object[0])).onClick.addListener(o -> {
            for (TableColumn<RECORD> column : this.table.getColumns()) {
                column.setDefaultWidth((int)((double)column.getDefaultWidth() * 1.5));
            }
            if (this.table.isForceFitWidth()) {
                this.table.setForceFitWidth(false);
            } else {
                this.table.reRenderIfRendered();
            }
        });
        itemView = new SimpleItemView();
        this.buttonOptions.setDropDownComponent(itemView);
        itemGroup = itemView.addSingleColumnGroup((Icon)MaterialIcon.ADD, this.context.getLocalized("dict.tableOptions", new Object[0]));
        itemGroup.addItem((Icon)MaterialIcon.ADD, (String)this.context.getLocalized((String)"dict.shadedRows", (Object[])new Object[0]), (String)this.context.getLocalized((String)"dict.displayTableWithShadedRows", (Object[])new Object[0])).onClick.addListener(o -> this.table.setStripedRows(!this.table.isStripedRows()));
        itemGroup.addItem((Icon)MaterialIcon.ADD, (String)this.context.getLocalized((String)"dict.showNumbering", (Object[])new Object[0]), (String)this.context.getLocalized((String)"dict.displayRowNumbers", (Object[])new Object[0])).onClick.addListener(o -> this.table.setShowNumbering(!this.table.isShowNumbering()));
        this.buttonFilter.onClick.addListener(toolbarButtonClickEvent -> {
            if (this.table.isShowHeaderRow()) {
                this.table.setShowHeaderRow(false);
                if (this.filterProvider != null) {
                    this.filterProvider.clearTablePropertyFilters();
                }
            } else {
                if (this.table.getHeaderRowFields().isEmpty()) {
                    this.table.setHeaderRowFields(this.table.getColumns().stream().collect(Collectors.toMap(col -> col.getPropertyName(), col -> {
                        String propertyName = col.getPropertyName();
                        TextField field = new TextField();
                        field.setEmptyText(this.context.getLocalized("dict.filter", new Object[0]) + "...");
                        field.onTextInput.addListener(s -> {
                            if (this.filterProvider == null) {
                                return;
                            }
                            if (StringUtils.isBlank((CharSequence)s)) {
                                this.filterProvider.setTablePropertyFilter(propertyName, null);
                            } else {
                                this.filterProvider.setTablePropertyFilter(propertyName, (String)s);
                            }
                        });
                        return field;
                    })));
                }
                this.table.setShowHeaderRow(true);
            }
        });
    }

    public List<ToolbarButtonGroup> getToolbarButtonGroups() {
        ArrayList<ToolbarButtonGroup> groups = new ArrayList<ToolbarButtonGroup>();
        ToolbarButtonGroup group = new ToolbarButtonGroup();
        groups.add(group);
        group.addButton(this.buttonAdd);
        group.addButton(this.buttonSave);
        group.addButton(this.buttonDiscardChanges);
        group.addButton(this.buttonDelete);
        group.addButton(this.buttonMultiDeleteRecord);
        group = new ToolbarButtonGroup();
        groups.add(group);
        group.addButton(this.buttonDisplayedColumns);
        group.addButton(this.buttonFilter);
        group.addButton(this.buttonOptions);
        return groups;
    }

    private void updateView(View view) {
        if (!this.table.equals(view.getComponent())) {
            return;
        }
        this.getToolbarButtonGroups().forEach(group -> view.addLocalButtonGroup((ToolbarButtonGroup)group));
    }
}

