/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.format;

import org.teamapps.dto.UiSpacing;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.absolutelayout.SizeUnit;

public class Spacing {
    private final Length top;
    private final Length right;
    private final Length bottom;
    private final Length left;

    public Spacing(int value) {
        this(new Length(value, SizeUnit.PIXEL), new Length(value, SizeUnit.PIXEL), new Length(value, SizeUnit.PIXEL), new Length(value, SizeUnit.PIXEL));
    }

    public Spacing(int verticalSpace, int horizontalSpace) {
        this(new Length(verticalSpace, SizeUnit.PIXEL), new Length(horizontalSpace, SizeUnit.PIXEL), new Length(verticalSpace, SizeUnit.PIXEL), new Length(horizontalSpace, SizeUnit.PIXEL));
    }

    public Spacing(int top, int right, int bottom, int left) {
        this(new Length(top, SizeUnit.PIXEL), new Length(right, SizeUnit.PIXEL), new Length(bottom, SizeUnit.PIXEL), new Length(left, SizeUnit.PIXEL));
    }

    public Spacing(Length top, Length right, Length bottom, Length left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public Length getTop() {
        return this.top;
    }

    public Length getRight() {
        return this.right;
    }

    public Length getBottom() {
        return this.bottom;
    }

    public Length getLeft() {
        return this.left;
    }

    public UiSpacing createUiSpacing() {
        if (this.top.getUnit() != SizeUnit.PIXEL || this.left.getUnit() != SizeUnit.PIXEL || this.bottom.getUnit() != SizeUnit.PIXEL || this.right.getUnit() != SizeUnit.PIXEL) {
            throw new IllegalArgumentException("UiSpacing currently only supports pixel values!");
        }
        UiSpacing uiSpacing = new UiSpacing();
        uiSpacing.setTop(this.top.getSize());
        uiSpacing.setRight(this.right.getSize());
        uiSpacing.setBottom(this.bottom.getSize());
        uiSpacing.setLeft(this.left.getSize());
        return uiSpacing;
    }

    public String toCssString() {
        return this.top.toCssString() + " " + this.right.toCssString() + " " + this.bottom.toCssString() + " " + this.left.toCssString();
    }
}

