/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map.shape;

import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.AbstractUiMapShape;
import org.teamapps.dto.UiMapPolyline;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.shape.AbstractMapShape;
import org.teamapps.ux.component.map.shape.ShapeProperties;

public class MapPolyline
extends AbstractMapShape {
    private List<Location> locations;

    public MapPolyline(ShapeProperties properties, List<Location> locations) {
        super(properties);
        this.locations = locations;
    }

    public UiMapPolyline createUiMapShape() {
        UiMapPolyline uiPolyline = new UiMapPolyline();
        this.mapAbstractUiShapeProperties((AbstractUiMapShape)uiPolyline);
        uiPolyline.setPath(this.locations.stream().map(Location::createUiLocation).collect(Collectors.toList()));
        return uiPolyline;
    }

    public MapPolyline addPoint(Location location) {
        this.locations.add(location);
        this.listener.handleChanged(this);
        return this;
    }

    public MapPolyline addPoints(List<Location> locations) {
        this.locations.addAll(locations);
        this.listener.handleChanged(this);
        return this;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public void setLocations(List<Location> locations) {
        this.locations = locations;
        this.listener.handleChanged(this);
    }
}

