/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.teamapps.dto.UiConfiguration;
import org.teamapps.dto.UiWeekDay;
import org.teamapps.ux.session.StylingTheme;

public class SessionConfiguration {
    private Locale languageLocale = Locale.ENGLISH;
    private ZoneId timeZone = ZoneId.of("Europe/Berlin");
    private String dateFormat = "yyyy-MM-dd";
    private String timeFormat = "HH:mm";
    private DayOfWeek firstDayOfWeek = DayOfWeek.MONDAY;
    private String decimalSeparator = ".";
    private String thousandsSeparator = "";
    private boolean optimizedForTouch = false;
    private String iconPath = "icons";
    private StylingTheme theme = StylingTheme.DEFAULT;
    private DateTimeFormatter dateFormatter;
    private DateTimeFormatter timeFormatter;
    private DateTimeFormatter dateTimeFormatter;

    public static SessionConfiguration createDefault() {
        return new SessionConfiguration();
    }

    public static SessionConfiguration create(Locale userLocale, ZoneId timeZone, StylingTheme theme, boolean optimizedForTouch) {
        SessionConfiguration config = new SessionConfiguration();
        config.setLanguageLocale(userLocale);
        config.setIconPath("icons");
        config.setTimeZone(timeZone);
        String dateFormat = ((SimpleDateFormat)DateFormat.getDateInstance(3, userLocale)).toPattern();
        config.setDateFormat(dateFormat);
        String timeFormat = ((SimpleDateFormat)DateFormat.getTimeInstance(3, userLocale)).toPattern();
        config.setTimeFormat(timeFormat);
        DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)DecimalFormat.getInstance(userLocale)).getDecimalFormatSymbols();
        config.setThousandsSeparator("" + decimalFormatSymbols.getGroupingSeparator());
        config.setDecimalSeparator("" + decimalFormatSymbols.getDecimalSeparator());
        config.setTheme(theme);
        config.setOptimizedForTouch(optimizedForTouch);
        return config;
    }

    public UiConfiguration createUiConfiguration() {
        UiConfiguration config = new UiConfiguration();
        config.setIsoLanguage(this.languageLocale.getLanguage());
        config.setTimeZoneId(this.timeZone.getId());
        config.setDateFormat(this.dateFormat);
        config.setTimeFormat(this.timeFormat);
        config.setFirstDayOfWeek(UiWeekDay.valueOf((String)this.firstDayOfWeek.name()));
        config.setDecimalSeparator(this.decimalSeparator);
        config.setThousandsSeparator(this.thousandsSeparator);
        config.setOptimizedForTouch(this.optimizedForTouch);
        config.setThemeClassName(this.theme.getCssClass());
        return config;
    }

    public Locale getLanguageLocale() {
        return this.languageLocale;
    }

    public void setLanguageLocale(Locale languageLocale) {
        this.languageLocale = languageLocale;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.dateFormatter = null;
        this.dateTimeFormatter = null;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        this.timeFormatter = null;
        this.dateTimeFormatter = null;
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public String getThousandsSeparator() {
        return this.thousandsSeparator;
    }

    public void setThousandsSeparator(String thousandsSeparator) {
        this.thousandsSeparator = thousandsSeparator;
    }

    public boolean isOptimizedForTouch() {
        return this.optimizedForTouch;
    }

    public void setOptimizedForTouch(boolean optimizedForTouch) {
        this.optimizedForTouch = optimizedForTouch;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public StylingTheme getTheme() {
        return this.theme;
    }

    public void setTheme(StylingTheme theme) {
        this.theme = theme;
    }

    public DateTimeFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = DateTimeFormatter.ofPattern(this.dateFormat);
        }
        return this.dateFormatter;
    }

    public DateTimeFormatter getTimeFormatter() {
        if (this.timeFormatter == null) {
            this.timeFormatter = DateTimeFormatter.ofPattern(this.timeFormat);
        }
        return this.timeFormatter;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateFormat + " " + this.timeFormat);
        }
        return this.dateTimeFormatter;
    }
}

