/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.webcontroller;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.icons.api.IconThemeImpl;
import org.teamapps.server.ServletRegistration;
import org.teamapps.server.UxServerContext;
import org.teamapps.ux.application.ApplicationBuilder;
import org.teamapps.ux.component.login.LoginAuthenticator;
import org.teamapps.ux.component.login.LoginWindow;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.StylingTheme;
import org.teamapps.webcontroller.ApplicationsController;
import org.teamapps.webcontroller.WebController;

public class SimpleApplicationWebController
implements WebController {
    public static final String CMD_LOGOUT = "cmdLogout";
    private List<ApplicationBuilder> applicationBuilders = new ArrayList<ApplicationBuilder>();
    private ApplicationBuilder settingsBuilder;
    private LoginAuthenticator authenticator;
    private List<String> preLaunchedApps = new ArrayList<String>();
    private String loginBackground = "/resources/backgrounds/login3.jpg";
    private String loginBackgroundBlurred = "/resources/backgrounds/login3-bl.jpg";
    private String defaultBackground = "/resources/backgrounds/default-bl.jpg";
    private Map<String, String> customAppBackgroundByAppName = new HashMap<String, String>();
    private Map<String, StylingTheme> stylingThemeByAppName = new HashMap<String, StylingTheme>();
    private Function<Locale, ResourceBundle> messageBundleProvider;
    private IconThemeImpl desktopIconTheme;
    private IconThemeImpl mobileIconTheme;
    private List<ServletRegistration> servletRegistrations = new ArrayList<ServletRegistration>();
    private List<Function<UxServerContext, ServletRegistration>> servletRegistrationFactories = new ArrayList<Function<UxServerContext, ServletRegistration>>();

    public void setLoginBackgroundUrls(String background, String backgroundBlurred) {
        this.loginBackground = background;
        this.loginBackgroundBlurred = backgroundBlurred;
    }

    public void setDefaultApplicationBackground(String background) {
        this.defaultBackground = background;
    }

    public void scanForApplications() {
        try {
            ClassInfoList widgetClasses = new ClassGraph().enableAllInfo().scan().getClassesImplementing(ApplicationBuilder.class.getName());
            widgetClasses.getStandardClasses().loadClasses().stream().forEach(app -> {
                try {
                    ApplicationBuilder applicationBuilder = (ApplicationBuilder)app.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.addApplicationBuilder(applicationBuilder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addApplicationBuilder(ApplicationBuilder applicationBuilder) {
        this.applicationBuilders.add(applicationBuilder);
    }

    public void addPreLaunchedApp(String applicationName) {
        this.preLaunchedApps.add(applicationName);
    }

    public void setSettingsBuilder(ApplicationBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
    }

    public ApplicationBuilder getApplicationBuilderByName(String appName) {
        return this.applicationBuilders.stream().filter(builder -> builder.getApplicationInfo().getName().equals(appName)).findAny().orElse(null);
    }

    public void registerCustomAppBackground(String appName, String background) {
        this.customAppBackgroundByAppName.put(appName, background);
    }

    public void registerCustomAppTheme(String appName, StylingTheme theme) {
        this.stylingThemeByAppName.put(appName, theme);
    }

    @Override
    public void onSessionStart(SessionContext context) {
        context.registerBackgroundImage("login", this.loginBackground, this.loginBackgroundBlurred);
        context.registerBackgroundImage("default", this.defaultBackground, this.defaultBackground);
        context.setBackgroundImage("login", 0);
        context.setCustomMessageBundleProvider(this.messageBundleProvider);
        if (!context.getClientInfo().getClientParameters().isEmpty()) {
            String string = context.getClientInfo().getClientUrl();
        }
        RootPanel rootPanel = new RootPanel();
        context.addRootComponent(null, rootPanel);
        LoginWindow loginWindow = new LoginWindow();
        if (this.authenticator != null) {
            loginWindow.onLogin.addListener(loginData -> {
                if (this.authenticator.loginSuccess(loginData.login, loginData.password, context)) {
                    this.createAndShowApplication(context, rootPanel, loginWindow);
                } else {
                    loginWindow.setError();
                }
            });
            rootPanel.setContent(loginWindow.getElegantPanel());
        } else {
            this.createAndShowApplication(context, rootPanel, loginWindow);
        }
        context.setBackgroundImage("login", 0);
        for (Map.Entry<String, String> entry : this.customAppBackgroundByAppName.entrySet()) {
            context.registerBackgroundImage(entry.getKey(), entry.getValue(), entry.getValue());
        }
    }

    private void createAndShowApplication(SessionContext context, RootPanel rootPanel, LoginWindow loginWindow) {
        context.setBackgroundImage("default", 750);
        ApplicationsController controller = new ApplicationsController(rootPanel, loginWindow, this.applicationBuilders, this.settingsBuilder, this.preLaunchedApps, this.customAppBackgroundByAppName, this.stylingThemeByAppName, context);
        controller.createUi();
    }

    @Override
    public Collection<ServletRegistration> getServletRegistrations(UxServerContext serverContext) {
        ArrayList<ServletRegistration> registrations = new ArrayList<ServletRegistration>();
        registrations.addAll(this.servletRegistrations);
        registrations.addAll(this.servletRegistrationFactories.stream().map(f -> (ServletRegistration)f.apply(serverContext)).collect(Collectors.toList()));
        return registrations;
    }

    public void setAuthenticator(LoginAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setMessageBundleProvider(Function<Locale, ResourceBundle> messageBundleProvider) {
        this.messageBundleProvider = messageBundleProvider;
    }

    public void setDefaultDesktopIconTheme(IconThemeImpl desktopIconTheme) {
        this.desktopIconTheme = desktopIconTheme;
    }

    public void setDefaultMobileIconTheme(IconThemeImpl mobileIconTheme) {
        this.mobileIconTheme = mobileIconTheme;
    }

    public void addServletRegistration(ServletRegistration servletRegistration) {
        this.servletRegistrations.add(servletRegistration);
    }

    public void addServletRegistrationFactory(Function<UxServerContext, ServletRegistration> servletRegistrationFactory) {
        this.servletRegistrationFactories.add(servletRegistrationFactory);
    }
}

