/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiButton;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;

public class Button<RECORD>
extends AbstractField<Boolean> {
    public final Event<Void> onDropDownOpened = new Event();
    private Template template = BaseTemplate.FORM_BUTTON;
    private RECORD templateRecord;
    private PropertyExtractor<RECORD> propertyExtractor = new BeanPropertyExtractor();
    private boolean openDropDownIfNotSet = false;
    private Component dropDownComponent;
    private Integer minDropDownWidth = null;
    private Integer minDropDownHeight = 300;

    public Button(Template template, RECORD templateRecord, Component dropDownComponent) {
        this.template = template;
        this.templateRecord = templateRecord;
        this.dropDownComponent = dropDownComponent;
    }

    public Button(Template template, RECORD templateRecord) {
        this(template, templateRecord, null);
    }

    public static Button<BaseTemplateRecord> create(Icon icon, String caption, Component dropDownComponent) {
        return new Button<BaseTemplateRecord>(BaseTemplate.FORM_BUTTON, new BaseTemplateRecord(icon, caption), dropDownComponent);
    }

    public static Button<BaseTemplateRecord> create(String caption, Component dropDownComponent) {
        return new Button<BaseTemplateRecord>(BaseTemplate.FORM_BUTTON, new BaseTemplateRecord(caption), dropDownComponent);
    }

    public static Button<BaseTemplateRecord> create(Icon icon, String caption) {
        return new Button<BaseTemplateRecord>(BaseTemplate.FORM_BUTTON, new BaseTemplateRecord(icon, caption));
    }

    public static Button<BaseTemplateRecord> create(String caption) {
        return new Button<BaseTemplateRecord>(BaseTemplate.FORM_BUTTON, new BaseTemplateRecord(caption));
    }

    public UiField createUiComponent() {
        Object uiRecord = this.createUiRecord();
        UiButton button = new UiButton(this.getTemplate().createUiTemplate(), uiRecord);
        this.mapAbstractFieldAttributesToUiField((UiField)button);
        button.setDropDownComponent(Component.createUiClientObjectReference(this.dropDownComponent));
        button.setMinDropDownWidth(this.minDropDownWidth != null ? this.minDropDownWidth : 0);
        button.setMinDropDownHeight(this.minDropDownHeight != null ? this.minDropDownHeight : 0);
        button.setOpenDropDownIfNotSet(this.openDropDownIfNotSet);
        return button;
    }

    private Object createUiRecord() {
        Object uiRecord = this.template != null ? this.propertyExtractor.getValues(this.templateRecord, this.template.getDataKeys()) : this.templateRecord.toString();
        return uiRecord;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_BUTTON_DROP_DOWN_OPENED: {
                this.onDropDownOpened.fire(null);
            }
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public Button<RECORD> setTemplate(Template template) {
        this.template = template;
        this.queueCommandIfRendered(() -> new UiButton.SetTemplateCommand(this.getId(), template.createUiTemplate(), this.createUiRecord()));
        return this;
    }

    public RECORD getTemplateRecord() {
        return this.templateRecord;
    }

    public Button<RECORD> setTemplateRecord(RECORD templateRecord) {
        this.templateRecord = templateRecord;
        this.queueCommandIfRendered(() -> new UiButton.SetTemplateRecordCommand(this.getId(), templateRecord));
        return this;
    }

    public Button<RECORD> setColor(Color color) {
        this.setCssStyle(".btn", "background-color", color.toHtmlColorString());
        return this;
    }

    public PropertyExtractor<RECORD> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public Integer getMinDropDownWidth() {
        return this.minDropDownWidth;
    }

    public Button<RECORD> setMinDropDownWidth(Integer minDropDownWidth) {
        this.minDropDownWidth = minDropDownWidth;
        this.queueCommandIfRendered(() -> new UiButton.SetDropDownSizeCommand(this.getId(), minDropDownWidth != null ? minDropDownWidth : 0, this.minDropDownHeight != null ? this.minDropDownHeight : 0));
        return this;
    }

    public Integer getMinDropDownHeight() {
        return this.minDropDownHeight;
    }

    public Button<RECORD> setMinDropDownHeight(Integer minDropDownHeight) {
        this.minDropDownHeight = minDropDownHeight;
        this.queueCommandIfRendered(() -> new UiButton.SetDropDownSizeCommand(this.getId(), this.minDropDownWidth != null ? this.minDropDownWidth : 0, minDropDownHeight != null ? minDropDownHeight : 0));
        return this;
    }

    public Button<RECORD> setMinDropDownSize(Integer minDropDownWidth, Integer minDropDownHeight) {
        this.minDropDownWidth = minDropDownWidth;
        this.minDropDownHeight = minDropDownHeight;
        this.queueCommandIfRendered(() -> new UiButton.SetDropDownSizeCommand(this.getId(), minDropDownWidth.intValue(), minDropDownHeight.intValue()));
        return this;
    }

    public boolean isOpenDropDownIfNotSet() {
        return this.openDropDownIfNotSet;
    }

    public Button<RECORD> setOpenDropDownIfNotSet(boolean openDropDownIfNotSet) {
        this.openDropDownIfNotSet = openDropDownIfNotSet;
        this.queueCommandIfRendered(() -> new UiButton.SetOpenDropDownIfNotSetCommand(this.getId(), openDropDownIfNotSet));
        return this;
    }

    public Component getDropDownComponent() {
        return this.dropDownComponent;
    }

    public Button<RECORD> setDropDownComponent(Component dropDownComponent) {
        this.dropDownComponent = dropDownComponent;
        this.queueCommandIfRendered(() -> new UiButton.SetDropDownComponentCommand(this.getId(), Component.createUiClientObjectReference(dropDownComponent)));
        return this;
    }
}

