/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map.shape;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiShapeProperties;

public class ShapeProperties {
    private Color strokeColor;
    private float strokeWeight = 2.0f;
    private String strokeDashArray;
    private Color fillColor = null;

    public ShapeProperties(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public ShapeProperties(Color strokeColor, float strokeWeight) {
        this.strokeColor = strokeColor;
        this.strokeWeight = strokeWeight;
    }

    public ShapeProperties(Color strokeColor, float strokeWeight, String strokeDashArray) {
        this.strokeColor = strokeColor;
        this.strokeWeight = strokeWeight;
        this.strokeDashArray = strokeDashArray;
    }

    public ShapeProperties(Color strokeColor, float strokeWeight, Color fillColor) {
        this.strokeColor = strokeColor;
        this.strokeWeight = strokeWeight;
        this.fillColor = fillColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public float getStrokeWeight() {
        return this.strokeWeight;
    }

    public void setStrokeWeight(float strokeWeight) {
        this.strokeWeight = strokeWeight;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public String getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public void setStrokeDashArray(String strokeDashArray) {
        this.strokeDashArray = strokeDashArray;
    }

    public UiShapeProperties createUiShapeProperties() {
        UiShapeProperties properties = new UiShapeProperties();
        properties.setFillColor(this.fillColor != null ? this.fillColor.toHtmlColorString() : null);
        properties.setStrokeColor(this.strokeColor != null ? this.strokeColor.toHtmlColorString() : null);
        properties.setStrokeWeight(this.strokeWeight);
        properties.setStrokeDashArray(this.strokeDashArray);
        return properties;
    }
}

