/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.media.webrtc;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiWebRtcPlayer;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.media.webrtc.VideoCodec;
import org.teamapps.ux.component.media.webrtc.WebRtcPlayingSettings;
import org.teamapps.ux.session.CurrentSessionContext;

public class WebRtcPlayer
extends AbstractComponent {
    private WebRtcPlayingSettings playingSettings;
    private String backgroundImageUrl;

    @Override
    public UiComponent createUiComponent() {
        UiWebRtcPlayer ui = new UiWebRtcPlayer();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setPlayingSettings(this.playingSettings != null ? this.playingSettings.createUiWebRtcPlayingSettings() : null);
        ui.setBackgroundImageUrl(this.backgroundImageUrl);
        return ui;
    }

    public static void getPlayableVideoCodecs(Consumer<List<VideoCodec>> resultCallback) {
        CurrentSessionContext.get().queueCommand(new UiWebRtcPlayer.GetPlayableVideoCodecsCommand(), uiVideoCodecs -> {
            List uiVideoCodecsAsIntegerList = (List)uiVideoCodecs;
            List codecs = uiVideoCodecsAsIntegerList.stream().map(uiCodec -> VideoCodec.values()[uiCodec]).collect(Collectors.toList());
            resultCallback.accept(codecs);
        });
    }

    public void play(String signalingUrl, String wowzaApplicationName, String streamName) {
        this.playingSettings = new WebRtcPlayingSettings(signalingUrl, wowzaApplicationName, streamName);
        this.queueCommandIfRendered(() -> new UiWebRtcPlayer.PlayCommand(this.getId(), this.playingSettings.createUiWebRtcPlayingSettings()));
    }

    public void stop() {
        this.playingSettings = null;
        this.queueCommandIfRendered(() -> new UiWebRtcPlayer.StopPlayingCommand(this.getId()));
    }

    public String getBackgroundImageUrl() {
        return this.backgroundImageUrl;
    }

    public void setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
        this.queueCommandIfRendered(() -> new UiWebRtcPlayer.SetBackgroundImageUrlCommand(this.getId(), backgroundImageUrl));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }
}

