/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import java.io.InputStream;
import java.util.function.Supplier;
import org.teamapps.ux.resource.Resource;

public class InputStreamResource
implements Resource {
    private final Supplier<InputStream> inputStreamSupplier;
    private final String name;
    private long length = -1L;

    public InputStreamResource(Supplier<InputStream> inputStreamSupplier) {
        this(inputStreamSupplier, -1L, null);
    }

    public InputStreamResource(Supplier<InputStream> inputStreamSupplier, String name) {
        this(inputStreamSupplier, -1L, name);
    }

    public InputStreamResource(Supplier<InputStream> inputStreamSupplier, long length) {
        this(inputStreamSupplier, length, null);
    }

    public InputStreamResource(Supplier<InputStream> inputStreamSupplier, long length, String name) {
        this.inputStreamSupplier = inputStreamSupplier;
        this.length = length;
        this.name = name;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStreamSupplier.get();
    }

    @Override
    public long getLength() {
        if (this.length < 0L) {
            this.length = Resource.super.getLength();
        }
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

