/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiSlider;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.field.AbstractField;

public class Slider
extends AbstractField<Number> {
    private double min = 0.0;
    private double max = 100.0;
    private double step = 1.0;
    private int displayedDecimals = 0;
    private Color selectionColor = new Color(51, 122, 183);
    private String tooltipPrefix;
    private String tooltipPostfix;
    private boolean humanReadableFileSize;

    public UiField createUiComponent() {
        UiSlider uiSlider = new UiSlider();
        this.mapAbstractFieldAttributesToUiField((UiField)uiSlider);
        uiSlider.setMin(this.min);
        uiSlider.setMax(this.max);
        uiSlider.setStep(this.step);
        uiSlider.setDisplayedDecimals(this.displayedDecimals);
        uiSlider.setSelectionColor(this.selectionColor != null ? UiUtil.createUiColor(this.selectionColor) : null);
        uiSlider.setTooltipPrefix(this.tooltipPrefix);
        uiSlider.setTooltipPostfix(this.tooltipPostfix);
        uiSlider.setHumanReadableFileSize(this.humanReadableFileSize);
        return uiSlider;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
        this.queueCommandIfRendered(() -> new UiSlider.SetMinCommand(this.getId(), min));
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.queueCommandIfRendered(() -> new UiSlider.SetMaxCommand(this.getId(), max));
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
        this.queueCommandIfRendered(() -> new UiSlider.SetStepCommand(this.getId(), step));
    }

    public int getDisplayedDecimals() {
        return this.displayedDecimals;
    }

    public void setDisplayedDecimals(int displayedDecimals) {
        this.displayedDecimals = displayedDecimals;
        this.queueCommandIfRendered(() -> new UiSlider.SetDisplayedDecimalsCommand(this.getId(), displayedDecimals));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.queueCommandIfRendered(() -> new UiSlider.SetSelectionColorCommand(this.getId(), selectionColor != null ? UiUtil.createUiColor(selectionColor) : null));
    }

    public String getTooltipPrefix() {
        return this.tooltipPrefix;
    }

    public void setTooltipPrefix(String tooltipPrefix) {
        this.tooltipPrefix = tooltipPrefix;
        this.queueCommandIfRendered(() -> new UiSlider.SetTooltipPrefixCommand(this.getId(), tooltipPrefix));
    }

    public String getTooltipPostfix() {
        return this.tooltipPostfix;
    }

    public void setTooltipPostfix(String tooltipPostfix) {
        this.tooltipPostfix = tooltipPostfix;
        this.queueCommandIfRendered(() -> new UiSlider.SetTooltipPostfixCommand(this.getId(), tooltipPostfix));
    }

    public boolean isHumanReadableFileSize() {
        return this.humanReadableFileSize;
    }

    public void setHumanReadableFileSize(boolean humanReadableFileSize) {
        this.humanReadableFileSize = humanReadableFileSize;
        this.queueCommandIfRendered(() -> new UiSlider.SetHumanReadableFileSizeCommand(this.getId(), humanReadableFileSize));
    }
}

