/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.extract;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.ValueExtractor;

public class PropertyProvider<RECORD>
implements PropertyExtractor<RECORD> {
    private Map<String, EntityProperty<RECORD>> propertyByName = new HashMap<String, EntityProperty<RECORD>>();
    private Map<String, EntityProperty<RECORD>> propertyByCaption = new HashMap<String, EntityProperty<RECORD>>();
    private Map<String, ValueExtractor<RECORD>> valueExtractorByPropertyName = new HashMap<String, ValueExtractor<RECORD>>();
    private Map<String, Function<RECORD, Instant>> instantExtractorProvider = new HashMap<String, Function<RECORD, Instant>>();
    private BeanPropertyExtractor beanPropertyExtractor;

    public PropertyProvider() {
        this(true);
    }

    public PropertyProvider(boolean useBeanPropertyExtractorFallback) {
        if (useBeanPropertyExtractorFallback) {
            this.beanPropertyExtractor = new BeanPropertyExtractor();
        }
    }

    public void addProperty(String propertyName, String caption, ValueExtractor<RECORD> valueExtractor) {
        EntityProperty<RECORD> property = new EntityProperty<RECORD>(propertyName, caption, valueExtractor);
        this.propertyByName.put(propertyName, property);
        this.propertyByCaption.put(caption, property);
    }

    @Override
    public Object getValue(RECORD record, String propertyName) {
        ValueExtractor<RECORD> extractor = this.getExtractor(record, propertyName);
        if (extractor != null) {
            return extractor.extract(record);
        }
        return null;
    }

    public Instant getInstantValue(RECORD record, String propertyName) {
        Function<RECORD, Instant> instantExtractor = this.getInstantExtractor(record, propertyName);
        if (instantExtractor != null) {
            return instantExtractor.apply(record);
        }
        return null;
    }

    private ValueExtractor<RECORD> getExtractor(RECORD record, String propertyName) {
        ValueExtractor<RECORD> valueExtractor = this.valueExtractorByPropertyName.get(propertyName);
        if (valueExtractor != null) {
            return valueExtractor;
        }
        EntityProperty<RECORD> property = this.propertyByName.get(propertyName);
        if (property != null) {
            valueExtractor = property.getValueExtractor();
        } else if (this.beanPropertyExtractor != null) {
            valueExtractor = this.beanPropertyExtractor.getValueExtractor(record.getClass(), propertyName);
        }
        if (valueExtractor != null) {
            this.valueExtractorByPropertyName.put(propertyName, valueExtractor);
        }
        return valueExtractor;
    }

    private Function<RECORD, Instant> getInstantExtractor(RECORD record, String propertyName) {
        Function<Object, Instant> instantExtractorFunction = this.instantExtractorProvider.get(propertyName);
        if (instantExtractorFunction != null) {
            return instantExtractorFunction;
        }
        ValueExtractor extractor = this.getExtractor(record, propertyName);
        if (extractor == null) {
            return null;
        }
        if (record.getClass().isAssignableFrom(Instant.class)) {
            instantExtractorFunction = rec -> (Instant)extractor.extract(rec);
        } else if (record.getClass().isAssignableFrom(Long.class)) {
            instantExtractorFunction = rec -> {
                Long value = (Long)extractor.extract(rec);
                return value == null ? null : Instant.ofEpochMilli(value);
            };
        } else if (record.getClass().isAssignableFrom(Integer.class)) {
            instantExtractorFunction = rec -> {
                Integer value = (Integer)extractor.extract(rec);
                return value == null ? null : Instant.ofEpochSecond(value.intValue());
            };
        } else if (record.getClass().isAssignableFrom(LocalDateTime.class)) {
            instantExtractorFunction = rec -> {
                LocalDateTime value = (LocalDateTime)extractor.extract(rec);
                return value == null ? null : value.toInstant(ZoneOffset.UTC);
            };
        }
        if (instantExtractorFunction != null) {
            this.instantExtractorProvider.put(propertyName, instantExtractorFunction);
        }
        return instantExtractorFunction;
    }

    public List<String> getPropertyNamesByCaptionQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return this.propertyByName.values().stream().map(property -> property.getName()).collect(Collectors.toList());
        }
        return this.propertyByName.values().stream().filter(property -> property.getCaption() != null && property.getCaption().toLowerCase().startsWith(query.toLowerCase())).map(property -> property.getName()).collect(Collectors.toList());
    }

    public static class EntityProperty<RECORD> {
        private String name;
        private String caption;
        private ValueExtractor<RECORD> valueExtractor;

        public EntityProperty(String name, String caption, ValueExtractor<RECORD> valueExtractor) {
            this.name = name;
            this.caption = caption;
            this.valueExtractor = valueExtractor;
        }

        public String getName() {
            return this.name;
        }

        public String getCaption() {
            return this.caption;
        }

        public ValueExtractor<RECORD> getValueExtractor() {
            return this.valueExtractor;
        }
    }
}

