/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value.filter;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.xdrop.fuzzywuzzy.FuzzySearch;
import org.teamapps.data.value.DataRecord;
import org.teamapps.data.value.filter.Filter;
import org.teamapps.data.value.filter.FilterType;

public class FullTextFilter
implements Filter {
    private String value;

    public FullTextFilter(String value) {
        this.value = value;
    }

    @Override
    public FilterType getType() {
        return FilterType.FULL_TEXT;
    }

    @Override
    public String getProperty() {
        return null;
    }

    @Override
    public boolean matches(DataRecord record, boolean treatNullAsDefaultValue) {
        if (this.value == null || this.value.isEmpty()) {
            return true;
        }
        List<String> keys = this.matchKeys(record.getPropertyNames());
        String compareValue = this.getValue().toLowerCase();
        boolean isExactSearch = this.isExactSearch(compareValue);
        boolean isFuzzySearch = this.isFuzzySearch(compareValue);
        boolean isWildcardSearch = this.isWildcardSearch(compareValue);
        String wildcardMatcher = this.createWildcardMatcher(compareValue);
        compareValue = this.cleanValue(compareValue);
        for (String key : keys) {
            Object value = record.getValue(key);
            if (value == null || value.toString() == null) continue;
            String stringValue = value.toString().toLowerCase();
            if (!(isFuzzySearch ? this.matchFuzzy(stringValue, compareValue) : (isExactSearch ? stringValue.equals(compareValue) : (isWildcardSearch ? stringValue.matches(wildcardMatcher) : stringValue.contains(compareValue))))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String explain(int filterLevel) {
        return this.createLevelIndentString(filterLevel) + "FULL-TEXT:  " + this.value + "\n";
    }

    private boolean isExactSearch(String value) {
        return value.startsWith("\"") || value.startsWith("'");
    }

    private String cleanValue(String value) {
        if (value.endsWith("+")) {
            int len = 1;
            if (value.endsWith("++")) {
                len = 2;
            }
            value = value.substring(0, value.length() - len);
        }
        value = value.replace("\"", "");
        value = value.replace("'", "");
        return value;
    }

    private boolean isFuzzySearch(String value) {
        return value.endsWith("+");
    }

    private boolean matchFuzzy(String val1, String val2) {
        int ratio = FuzzySearch.ratio((String)val1, (String)val2);
        return ratio > 50;
    }

    private boolean isWildcardSearch(String value) {
        return value.contains("*") || value.contains("?");
    }

    private String createWildcardMatcher(String value) {
        StringBuilder out = new StringBuilder("^");
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append(".*$");
        return out.toString();
    }

    private String getFieldMatcher() {
        int pos = this.value.indexOf(58);
        if (pos <= 0) {
            return null;
        }
        return this.value.substring(0, pos).toLowerCase();
    }

    private String getValue() {
        int pos = this.value.indexOf(58);
        if (pos <= 0) {
            return this.value;
        }
        return this.value.substring(pos + 1);
    }

    private List<String> matchKeys(List<String> keys) {
        int pos = this.value.indexOf(58);
        if (pos <= 0) {
            return keys;
        }
        String matcher = this.value.substring(0, pos).toLowerCase();
        return keys.stream().filter(key -> key.toLowerCase().contains(matcher)).collect(Collectors.toList());
    }

    public Filter parseSearch(List<String> fieldNames, Map<String, String> captionsByFieldName) {
        if (this.value == null || this.value.isEmpty()) {
            return null;
        }
        return null;
    }

    public static void main(String[] args) {
        String a = "test:gg";
        int pos = a.indexOf(58);
        System.out.println(a.substring(0, pos));
        System.out.println(a.substring(pos));
    }

    private static class AndOrPart {
        private String query;
        private boolean isOr;

        private AndOrPart() {
        }
    }
}

