/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value.filter;

import java.util.Objects;
import me.xdrop.fuzzywuzzy.FuzzySearch;
import org.teamapps.data.value.DataRecord;
import org.teamapps.data.value.filter.AbstractFilter;
import org.teamapps.data.value.filter.FilterType;

public class TextFilter
extends AbstractFilter {
    private final String value;
    private final Comparator comparator;

    public TextFilter(String property, String value, Comparator comparator) {
        super(property);
        this.value = value;
        this.comparator = comparator;
    }

    @Override
    public FilterType getType() {
        return FilterType.TEXT;
    }

    @Override
    public boolean matches(DataRecord record, boolean treatNullAsDefaultValue) {
        Object recordValue = record.getValue(this.getProperty());
        String matchValue = "";
        if (recordValue != null) {
            matchValue = recordValue.toString();
        }
        if (!treatNullAsDefaultValue && recordValue == null) {
            return false;
        }
        switch (this.comparator) {
            case EQUAL: {
                return Objects.equals(matchValue, this.value);
            }
            case UNEQUAL: {
                return !Objects.equals(matchValue, this.value);
            }
            case STARTS_WITH: {
                return matchValue.startsWith(this.value);
            }
            case STARTS_NOT_WITH: {
                return !matchValue.startsWith(this.value);
            }
            case WILDCARD: {
                return matchValue.matches(TextFilter.createMatchingRegex(this.value));
            }
            case UNEQUAL_WILDCARD: {
                return !matchValue.matches(TextFilter.createMatchingRegex(this.value));
            }
            case FUZZY: {
                int ratio = FuzzySearch.ratio((String)matchValue, (String)this.value);
                return ratio > 80;
            }
            case UNEQUAL_FUZZY: {
                int ratio2 = FuzzySearch.ratio((String)matchValue, (String)this.value);
                return ratio2 < 80;
            }
        }
        return false;
    }

    private static String createMatchingRegex(String value) {
        StringBuilder out = new StringBuilder("^");
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('$');
        return out.toString();
    }

    @Override
    public String explain(int filterLevel) {
        return this.createLevelIndentString(filterLevel) + "TEXT: " + this.getProperty() + " " + this.comparator.name() + " " + this.value + "\n";
    }

    public String getValue() {
        return this.value;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public static enum Comparator {
        EQUAL,
        UNEQUAL,
        STARTS_WITH,
        STARTS_NOT_WITH,
        WILDCARD,
        UNEQUAL_WILDCARD,
        FUZZY,
        UNEQUAL_FUZZY;

    }
}

