/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.teamapps.ux.session.StylingTheme;

public interface ApplicationTheme {
    public static ApplicationTheme createTheme(String applicationBackgroundImage) {
        return ApplicationTheme.createTheme(applicationBackgroundImage, null, null, null, null, null);
    }

    public static ApplicationTheme createTheme(String applicationBackgroundImage, StylingTheme applicationTheme) {
        return ApplicationTheme.createTheme(applicationBackgroundImage, null, null, applicationTheme, null, null);
    }

    public static ApplicationTheme createTheme(File applicationBackgroundImageFile) {
        return ApplicationTheme.createTheme(null, applicationBackgroundImageFile, null, null, null, null);
    }

    public static ApplicationTheme createTheme(File applicationBackgroundImageFile, StylingTheme applicationTheme) {
        return ApplicationTheme.createTheme(null, applicationBackgroundImageFile, null, applicationTheme, null, null);
    }

    public static ApplicationTheme createTheme(URL applicationBackgroundImageURL) {
        return ApplicationTheme.createTheme(null, null, applicationBackgroundImageURL, null, null, null);
    }

    public static ApplicationTheme createTheme(URL applicationBackgroundImageURL, StylingTheme applicationTheme) {
        return ApplicationTheme.createTheme(null, null, applicationBackgroundImageURL, applicationTheme, null, null);
    }

    public static ApplicationTheme createTheme(String applicationBackgroundImage, StylingTheme applicationTheme, String customIconStyleId, String customIconLibraryId) {
        return ApplicationTheme.createTheme(applicationBackgroundImage, null, null, applicationTheme, customIconStyleId, customIconLibraryId);
    }

    private static File loadFile(URL url) {
        try {
            File tempFile = File.createTempFile("background", "jpg");
            IOUtils.copy((InputStream)url.openStream(), (OutputStream)new FileOutputStream(tempFile));
            return tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ApplicationTheme createTheme(final String applicationBackgroundImage, File applicationBackgroundImageFile, URL applicationBackgroundImageURL, final StylingTheme applicationTheme, final String customIconStyleId, final String customIconLibraryId) {
        if (applicationBackgroundImageURL != null && applicationBackgroundImageFile == null) {
            applicationBackgroundImageFile = ApplicationTheme.loadFile(applicationBackgroundImageURL);
        }
        final File backgroundFile = applicationBackgroundImageFile;
        return new ApplicationTheme(){

            @Override
            public String getApplicationBackgroundImage() {
                return applicationBackgroundImage;
            }

            @Override
            public File geApplicationBackgroundImageFile() {
                return backgroundFile;
            }

            @Override
            public StylingTheme getApplicationTheme() {
                if (applicationTheme == null) {
                    return StylingTheme.DEFAULT;
                }
                return applicationTheme;
            }

            @Override
            public String getCustomIconStyleId() {
                return customIconStyleId;
            }

            @Override
            public String getCustomIconLibraryId() {
                return customIconLibraryId;
            }
        };
    }

    public String getApplicationBackgroundImage();

    public File geApplicationBackgroundImageFile();

    public StylingTheme getApplicationTheme();

    public String getCustomIconStyleId();

    public String getCustomIconLibraryId();
}

