/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.application.ApplicationLauncher;
import org.teamapps.ux.application.ManagedResourceBundleProvider;
import org.teamapps.ux.application.ResponsiveApplicationBuilder;
import org.teamapps.ux.application.RootWindowHandler;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;

public class ResponsiveApplicationGroup {
    private final View applicationLauncher;
    private final ManagedResourceBundleProvider managedResourceBundleProvider;
    private final RootWindowHandler rootWindowHandler;
    private final List<ResponsiveApplicationBuilder> applicationBuilders = new ArrayList<ResponsiveApplicationBuilder>();

    public ResponsiveApplicationGroup(View applicationLauncher, ManagedResourceBundleProvider managedResourceBundleProvider, RootWindowHandler rootWindowHandler) {
        this.applicationLauncher = applicationLauncher;
        this.managedResourceBundleProvider = managedResourceBundleProvider;
        this.rootWindowHandler = rootWindowHandler;
    }

    public ApplicationLauncher addApplication(final ResponsiveApplicationBuilder applicationBuilder) {
        if (applicationBuilder.getApplicationResourceBundleInfo() != null) {
            this.managedResourceBundleProvider.registerApplicationResourceBundle(applicationBuilder);
        }
        this.applicationBuilders.add(applicationBuilder);
        return new ApplicationLauncher(){

            @Override
            public View getLauncherView() {
                return ResponsiveApplicationGroup.this.applicationLauncher;
            }

            @Override
            public ResourceBundle getManagedApplicationResourceBundle(Locale locale) {
                if (applicationBuilder.getApplicationResourceBundleInfo() == null) {
                    return null;
                }
                return ResponsiveApplicationGroup.this.managedResourceBundleProvider.getManagedResourceBundle(applicationBuilder, locale);
            }

            @Override
            public void showTopLevelComponent(Icon icon, String title, Component component) {
                ResponsiveApplicationGroup.this.rootWindowHandler.showTopLevelComponent(applicationBuilder, icon, title, component);
            }

            @Override
            public void removeTopLevelComponent(Component component) {
                ResponsiveApplicationGroup.this.rootWindowHandler.removeTopLevelComponent(applicationBuilder, component);
            }

            @Override
            public String createCustomApplicationEntryURL(boolean authenticateUser, boolean loadApplicationLauncher, Map<String, String> parameterMap) {
                return ResponsiveApplicationGroup.this.rootWindowHandler.createCustomApplicationEntryURL(applicationBuilder, authenticateUser, loadApplicationLauncher, parameterMap);
            }

            @Override
            public String createCustomApplicationEntryURL(boolean authenticateUser, boolean loadApplicationLauncher, TimeUnit validityTimeUnit, long validityDuration, Map<String, String> parameterMap) {
                return ResponsiveApplicationGroup.this.rootWindowHandler.createCustomApplicationEntryURL(applicationBuilder, authenticateUser, loadApplicationLauncher, validityTimeUnit, validityDuration, parameterMap);
            }
        };
    }
}

