/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.ux.application.model.AbstractPerspectiveDataModel;

public class ListPerspectiveDataModel<RECORD>
extends AbstractPerspectiveDataModel<RECORD> {
    private List<RECORD> records = new ArrayList<RECORD>();

    public ListPerspectiveDataModel(PropertyProvider<RECORD> propertyProvider) {
        super(propertyProvider);
    }

    public void addRecord(RECORD record) {
        this.records.add(record);
    }

    @Override
    public int getRecordCount() {
        return this.records.size();
    }

    @Override
    public List<RECORD> getEntities(int startIndex, int length, Instant start, Instant end, Sorting sorting) {
        List<RECORD> list;
        if (startIndex == 0 && length >= this.records.size()) {
            list = Collections.unmodifiableList(this.records);
        } else {
            int len = Math.min(length, this.records.size());
            list = this.records.subList(startIndex, Math.min(startIndex + len, this.records.size() - startIndex));
        }
        PropertyProvider propertyProvider = this.getPropertyProvider();
        if (start == null || end == null || start.getEpochSecond() < end.getEpochSecond()) {
            // empty if block
        }
        if (sorting != null && sorting.getFieldName() != null) {
            Comparator<Object> comparator = Comparator.comparing(record -> (Comparable)propertyProvider.getValue(record, sorting.getFieldName()));
            if (SortDirection.DESC == sorting.getSorting()) {
                comparator = comparator.reversed();
            }
            Collections.sort(list, comparator);
        }
        return list;
    }
}

